/*
 * Decompiled with CFR 0.152.
 */
package com.rabriel;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class GivenWhenThen<T> {
    public static final String WHEN_FUNCTION_FAILED = "When function failed.";
    public static final String FAILED = " - failed";
    public static final String THEN_NOT_SATISFIED = "Then not satisfied.";
    public static final String THEN_FUNCTION_FAILED = "Then function failed.";
    public static final String FUTURE_FAILED = "Given future failed.";
    private T received;

    private GivenWhenThen(T received) {
        this.received = received;
    }

    private GivenWhenThen(Future<T> received) {
        if (received == null) {
            this.received = null;
            return;
        }
        try {
            this.received = received.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(FUTURE_FAILED, e);
        }
    }

    public <F> GivenWhenThen<F> when(Function<T, F> whenFunction) {
        return this.when(null, whenFunction);
    }

    public <F> GivenWhenThen<F> when(String message, Function<T, F> whenFunction) {
        try {
            return new GivenWhenThen<F>(whenFunction.apply(this.received));
        }
        catch (Exception ex) {
            throw new RuntimeException(message == null ? WHEN_FUNCTION_FAILED : message + FAILED, ex);
        }
    }

    public void then(Predicate<T> thenFunction) {
        this.then(null, thenFunction);
    }

    public void then(String failMessage, Predicate<T> thenFunction) {
        boolean testResult = thenFunction.test(this.received);
        if (!testResult) {
            throw new RuntimeException(failMessage == null ? THEN_NOT_SATISFIED : failMessage);
        }
    }

    public void then(Consumer<T> thenFunction) {
        this.then(null, thenFunction);
    }

    public void then(String message, Consumer<T> thenFunction) {
        try {
            thenFunction.accept(this.received);
        }
        catch (Exception ex) {
            throw new RuntimeException(message == null ? THEN_FUNCTION_FAILED : message + FAILED, ex);
        }
    }

    public static <E> GivenWhenThen<E> given(E receivedObj) {
        return GivenWhenThen.given(null, receivedObj);
    }

    public static <E> GivenWhenThen<E> given(String message, E receivedObj) {
        return new GivenWhenThen<E>(receivedObj);
    }

    public static <E> GivenWhenThen<E> given(Future<E> receivedObj) {
        return GivenWhenThen.given(null, receivedObj);
    }

    public static <E> GivenWhenThen<E> given(String message, Future<E> receivedObj) {
        return new GivenWhenThen<E>(receivedObj);
    }
}

