/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.xs.ListDV;
import org.apache.xerces.xs.ShortList;

public class EqualityHelper {
    private EqualityHelper() {
    }

    public static boolean isEqual(Object value1, Object value2, short value1Type, short value2Type, ShortList typeList1, ShortList typeList2, short schemaVersion) {
        if (schemaVersion == 4) {
            return EqualityHelper.isEqual11(value1, value2, value1Type, value2Type, typeList1, typeList2);
        }
        return EqualityHelper.isEqual(value1, value2, value1Type, value2Type, typeList1, typeList2);
    }

    public static boolean isEqual(ValidatedInfo value1, ValidatedInfo value2, short schemaVersion) {
        if (schemaVersion == 4) {
            return EqualityHelper.isEqual11(value1.actualValue, value2.actualValue, value1.actualValueType, value2.actualValueType, value1.itemValueTypes, value2.itemValueTypes);
        }
        return EqualityHelper.isEqual(value1.actualValue, value2.actualValue, value1.actualValueType, value2.actualValueType, value1.itemValueTypes, value2.itemValueTypes);
    }

    private static boolean isEqual(Object value1, Object value2, short value1Type, short value2Type, ShortList typeList1, ShortList typeList2) {
        if (!EqualityHelper.isTypeComparable(value1Type, value2Type, typeList1, typeList2)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    private static boolean isTypeComparable(short type1, short type2, ShortList typeList1, ShortList typeList2) {
        short primitiveType2;
        short primitiveType1 = EqualityHelper.convertToPrimitiveKind(type1);
        if (primitiveType1 == (primitiveType2 = EqualityHelper.convertToPrimitiveKind(type2))) {
            if (primitiveType1 == 44) {
                return EqualityHelper.isListTypeComparable(typeList1, typeList2);
            }
            return true;
        }
        return primitiveType1 == 1 && primitiveType2 == 2 || primitiveType1 == 2 && primitiveType2 == 1;
    }

    private static boolean isEqual11(Object value1, Object value2, short value1Type, short value2Type, ShortList typeList1, ShortList typeList2) {
        if (!EqualityHelper.isType11Comparable(value1Type, value2Type, typeList1, typeList2)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof ListDV.ListData) {
            if (!(value2 instanceof ListDV.ListData)) {
                ListDV.ListData listData = (ListDV.ListData)value1;
                if (listData.getLength() != 1) {
                    return false;
                }
                value1 = listData.get(0);
            }
        } else if (value2 instanceof ListDV.ListData) {
            ListDV.ListData listData = (ListDV.ListData)value2;
            if (listData.getLength() != 1) {
                return false;
            }
            value2 = listData.get(0);
        }
        return value1.equals(value2);
    }

    private static boolean isType11Comparable(short type1, short type2, ShortList typeList1, ShortList typeList2) {
        short primitiveType2;
        short primitiveType1 = EqualityHelper.convertToPrimitiveKind(type1);
        if (primitiveType1 == (primitiveType2 = EqualityHelper.convertToPrimitiveKind(type2))) {
            if (primitiveType1 == 44) {
                return EqualityHelper.isListTypeComparable(typeList1, typeList2);
            }
            return true;
        }
        if (primitiveType1 == 44) {
            if (typeList1 == null || typeList1.getLength() != 1) {
                return false;
            }
            return EqualityHelper.isType11Comparable(typeList1.item(0), primitiveType2, null, null);
        }
        if (primitiveType2 == 44) {
            if (typeList2 == null || typeList2.getLength() != 1) {
                return false;
            }
            return EqualityHelper.isType11Comparable(primitiveType1, typeList2.item(0), null, null);
        }
        return primitiveType1 == 1 && primitiveType2 == 2 || primitiveType1 == 2 && primitiveType2 == 1;
    }

    private static short convertToPrimitiveKind(short valueType) {
        if (valueType <= 20) {
            return valueType;
        }
        if (valueType <= 29) {
            return 2;
        }
        if (valueType <= 42) {
            return 4;
        }
        if (valueType == 44 || valueType == 43) {
            return 44;
        }
        return valueType;
    }

    private static boolean isListTypeComparable(ShortList typeList1, ShortList typeList2) {
        int typeList2Length;
        int typeList1Length = typeList1 != null ? typeList1.getLength() : 0;
        int n = typeList2Length = typeList2 != null ? typeList2.getLength() : 0;
        if (typeList1Length != typeList2Length) {
            return false;
        }
        for (int i = 0; i < typeList1Length; ++i) {
            short primitiveItem2;
            short primitiveItem1 = EqualityHelper.convertToPrimitiveKind(typeList1.item(i));
            if (primitiveItem1 == (primitiveItem2 = EqualityHelper.convertToPrimitiveKind(typeList2.item(i))) || primitiveItem1 == 1 && primitiveItem2 == 2 || primitiveItem1 == 2 && primitiveItem2 == 1) continue;
            return false;
        }
        return true;
    }
}

