/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.xerces.dom;

import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

/**
 * Represents an XML (or HTML) comment.
 * 
 * @xerces.internal
 *
 * @version $Id$
 * @since  PR-DOM-Level-1-19980818.
 */
public class CommentImpl 
    extends CharacterDataImpl 
    implements CharacterData, Comment {

    //
    // Constants
    //

    /** Serialization version. */
    static final long serialVersionUID = -2685736833408134044L;

    //
    // Constructors
    //

    /** Factory constructor. */
    public CommentImpl(CoreDocumentImpl ownerDoc, String data) {
    	super(ownerDoc, data);
    }
    
    //
    // Node methods
    //

    /** 
     * A short integer indicating what type of node this is. The named
     * constants for this value are defined in the org.w3c.dom.Node interface.
     */
    public short getNodeType() {
        return Node.COMMENT_NODE;
    }

    /** Returns the node name. */
    public String getNodeName() {
        return "#comment";
    }

} // class CommentImpl
