/*
 * Decompiled with CFR 0.152.
 */
package com.rameshkp.openapi.merger.gradle.task;

import com.rameshkp.openapi.merger.app.OpenApiMergerApp;
import com.rameshkp.openapi.merger.app.exceptions.OpenApiDataInvalidException;
import com.rameshkp.openapi.merger.app.models.Contact;
import com.rameshkp.openapi.merger.app.models.ExternalDocs;
import com.rameshkp.openapi.merger.app.models.Info;
import com.rameshkp.openapi.merger.app.models.License;
import com.rameshkp.openapi.merger.app.models.OpenApi;
import com.rameshkp.openapi.merger.app.models.Server;
import com.rameshkp.openapi.merger.gradle.extensions.InfoExtension;
import com.rameshkp.openapi.merger.gradle.extensions.OpenApiExtension;
import com.rameshkp.openapi.merger.gradle.extensions.OpenApiMergerExtension;
import com.rameshkp.openapi.merger.gradle.extensions.ServerExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u001f\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001b0\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00020\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/rameshkp/openapi/merger/gradle/task/OpenApiMergerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "defaultOutputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "defaultOutputFileExtension", "", "defaultOutputFileName", "inputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "openApiMergerExtension", "Lcom/rameshkp/openapi/merger/gradle/extensions/OpenApiMergerExtension;", "outputFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "validFileExtension", "", "execute", "", "isAnyValueNotNull", "", "array", "", "", "([Ljava/lang/Object;)Z", "validateAndSetValues", "openapi-merger-gradle-plugin"})
public class OpenApiMergerTask
extends DefaultTask {
    @NotNull
    private final DirectoryProperty inputDirectory;
    @NotNull
    private final RegularFileProperty outputFileProperty;
    private final OpenApiMergerExtension openApiMergerExtension;
    private final List<String> validFileExtension;
    private final Provider<Directory> defaultOutputDir;
    private final String defaultOutputFileName;
    private final String defaultOutputFileExtension;

    @SkipWhenEmpty
    @InputDirectory
    @NotNull
    public final DirectoryProperty getInputDirectory() {
        return this.inputDirectory;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getOutputFileProperty() {
        return this.outputFileProperty;
    }

    private final void validateAndSetValues() {
        Property<String> outputFileExtension = this.openApiMergerExtension.getOutput$openapi_merger_gradle_plugin().getFileExtension();
        if (!outputFileExtension.isPresent()) {
            outputFileExtension.set((Object)this.defaultOutputFileExtension);
        }
        if (!this.validFileExtension.contains(outputFileExtension.get())) {
            throw (Throwable)new GradleException("Invalid file extension " + (String)outputFileExtension.get() + ". Valid values are " + this.validFileExtension);
        }
        Directory outputDir = (Directory)this.openApiMergerExtension.getOutput$openapi_merger_gradle_plugin().getDirectory().getOrElse(this.defaultOutputDir.get());
        String outputFileName = (String)this.openApiMergerExtension.getOutput$openapi_merger_gradle_plugin().getFileName().getOrElse((Object)this.defaultOutputFileName);
        Project project = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Directory directory = outputDir;
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"outputDir");
        this.outputFileProperty.set(project.file((Object)stringBuilder.append(directory.getAsFile()).append('/').append(outputFileName).append('.').append((String)outputFileExtension.get()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void execute() {
        void var25_33;
        void var23_31;
        void info;
        File outputFile;
        File file = outputFile = (File)this.outputFileProperty.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputFile");
        file.getParentFile().mkdirs();
        OpenApiExtension openApiExtension = this.openApiMergerExtension.getOpenApi$openapi_merger_gradle_plugin();
        OpenApi openApi2 = new OpenApi(null, null, null, null, 15, null);
        boolean bl = false;
        boolean bl2 = false;
        OpenApi $this$run = openApi2;
        boolean bl3 = false;
        $this$run.setVersion((String)openApiExtension.getOpenApiVersion().getOrNull());
        Info info2 = new Info(null, null, null, null, null, null, 63, null);
        boolean bl4 = false;
        boolean bl5 = false;
        Info info3 = info2;
        OpenApi openApi3 = $this$run;
        boolean bl6 = false;
        InfoExtension infoExtension = openApiExtension.getInfo();
        info.setTitle((String)infoExtension.getTitle().getOrNull());
        info.setDescription((String)infoExtension.getDescription().getOrNull());
        info.setVersion((String)infoExtension.getVersion().getOrNull());
        info.setTermsOfService((String)infoExtension.getTermsOfService().getOrNull());
        String contactUrl = (String)infoExtension.getContact$openapi_merger_gradle_plugin().getUrl().getOrNull();
        String contactName = (String)infoExtension.getContact$openapi_merger_gradle_plugin().getName().getOrNull();
        String contactEmail = (String)infoExtension.getContact$openapi_merger_gradle_plugin().getEmail().getOrNull();
        if (this.isAnyValueNotNull(new Object[]{contactUrl, contactName, contactEmail})) {
            void contact;
            Contact contact2 = new Contact(null, null, null, 7, null);
            boolean bl7 = false;
            boolean bl8 = false;
            Contact contact3 = contact2;
            var23_31 = info;
            boolean bl9 = false;
            contact.setUrl(contactUrl);
            contact.setEmail(contactEmail);
            contact.setName(contactName);
            var25_33 = contact;
            var23_31.setContact((Contact)var25_33);
        }
        String licenseName = (String)infoExtension.getLicense$openapi_merger_gradle_plugin().getName().getOrNull();
        String licenseUrl = (String)infoExtension.getLicense$openapi_merger_gradle_plugin().getUrl().getOrNull();
        if (this.isAnyValueNotNull(new Object[]{licenseName, licenseUrl})) {
            void license;
            License license2 = new License(null, null, 3, null);
            boolean bl10 = false;
            boolean bl11 = false;
            License license3 = license2;
            var23_31 = info;
            boolean bl12 = false;
            license.setName(licenseName);
            license.setUrl(licenseUrl);
            var25_33 = license;
            var23_31.setLicense((License)var25_33);
        }
        void var28_36 = info;
        openApi3.setInfo((Info)var28_36);
        String externalDocsUrl = (String)openApiExtension.getExternalDocs$openapi_merger_gradle_plugin().getUrl().getOrNull();
        String externalDocsDescription = (String)openApiExtension.getExternalDocs$openapi_merger_gradle_plugin().getDescription().getOrNull();
        if (this.isAnyValueNotNull(new Object[]{externalDocsUrl, externalDocsDescription})) {
            void eDocs;
            ExternalDocs externalDocs = new ExternalDocs(null, null, 3, null);
            boolean bl13 = false;
            boolean bl14 = false;
            infoExtension = externalDocs;
            openApi3 = $this$run;
            boolean bl15 = false;
            eDocs.setUrl(externalDocsUrl);
            eDocs.setDescription(externalDocsDescription);
            var28_36 = eDocs;
            openApi3.setExternalDocs((ExternalDocs)var28_36);
        }
        ArrayList servers2 = new ArrayList();
        openApiExtension.getServers().all((Action)new Action<ServerExtension>(servers2){
            final /* synthetic */ ArrayList $servers;

            public final void execute(ServerExtension it) {
                this.$servers.add(new Server((String)it.getUrl().getOrNull(), (String)it.getDescription().getOrNull()));
            }
            {
                this.$servers = arrayList;
            }
        });
        $this$run.setServers((List)servers2);
        OpenApi openApi4 = $this$run;
        OpenApiMergerApp openApiMergerApp = new OpenApiMergerApp();
        try {
            Object object = this.inputDirectory.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputDirectory.get()");
            File file2 = ((Directory)object).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"inputDirectory.get().asFile");
            openApiMergerApp.merge(file2, outputFile, openApi4);
        }
        catch (OpenApiDataInvalidException e) {
            this.getLogger().error("Error merging openapi files", (Throwable)e);
            throw (Throwable)new GradleException("Error merging openapi files. Reason=\n" + e.getMessage());
        }
    }

    private final boolean isAnyValueNotNull(Object[] array) {
        Collection collection = ArraysKt.filterNotNull((Object[])array);
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public OpenApiMergerTask() {
        OpenApiMergerExtension openApiMergerExtension;
        void $this$run;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        DirectoryProperty directoryProperty = project.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.inputDirectory = directoryProperty;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        RegularFileProperty regularFileProperty = project2.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.outputFileProperty = regularFileProperty;
        this.validFileExtension = CollectionsKt.listOf((Object[])new String[]{"yaml", "json", "yml"});
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        ProjectLayout projectLayout = project3.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        Provider provider = projectLayout.getBuildDirectory().dir("open-api");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDirectory.dir(\"open-api\")");
        this.defaultOutputDir = provider;
        this.defaultOutputFileName = "openapi";
        this.defaultOutputFileExtension = "yaml";
        this.setGroup("Open Api Merger");
        this.setDescription("Task to merge multiple openapi files");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        ExtensionContainer extensionContainer = project4.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer extensionContainer2 = extensionContainer;
        OpenApiMergerTask openApiMergerTask = this;
        boolean bl3 = false;
        Object object = $this$run.getByName("openApiMerger");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.rameshkp.openapi.merger.gradle.extensions.OpenApiMergerExtension");
        }
        openApiMergerTask.openApiMergerExtension = openApiMergerExtension = (OpenApiMergerExtension)object;
        this.inputDirectory.set((Provider)this.openApiMergerExtension.getInputDirectory());
        this.validateAndSetValues();
    }
}

