/*
 * Decompiled with CFR 0.152.
 */
package com.randomnoun.maven.plugin.yamlCombine;

import com.randomnoun.maven.plugin.yamlCombine.YamlCombiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.DefaultMavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="yaml-combine", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class YamlCombineMojo
extends AbstractMojo {
    @Parameter(property="fileset")
    private FileSet fileset;
    @Parameter(defaultValue="UTF-8", required=false)
    private String fileSetEncoding;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="UTF-8", required=false)
    private String outputFileEncoding;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="filtering", defaultValue="false", required=true)
    private boolean filtering;
    @Parameter(property="verbose", defaultValue="false", required=true)
    private boolean verbose;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private BuildContext buildContext;
    private Settings settings;
    @Component
    private MavenProjectHelper projectHelper;

    private DirectoryScanner scan(FileSet fileSet) {
        File basedir = new File(fileSet.getDirectory());
        if (!basedir.exists() || !basedir.isDirectory()) {
            return null;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includesArray = fileSet.getIncludesArray();
        String[] excludesArray = fileSet.getExcludesArray();
        if (includesArray.length > 0) {
            scanner.setIncludes(includesArray);
        }
        if (excludesArray.length > 0) {
            scanner.setExcludes(excludesArray);
        }
        if (fileSet.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        scanner.setBasedir(basedir);
        scanner.setFollowSymlinks(fileSet.isFollowSymlinks());
        scanner.scan();
        return scanner;
    }

    public File createCombinedYaml() throws MojoExecutionException {
        if (this.outputDirectory == null) {
            throw new IllegalArgumentException("Missing outputDirectory");
        }
        if (this.finalName == null) {
            throw new IllegalArgumentException("Missing finalName");
        }
        File destFile = new File(this.outputDirectory, this.finalName);
        Charset outputFileCharset = Charset.forName(this.outputFileEncoding);
        Charset inputFileSetCharset = Charset.forName(this.fileSetEncoding);
        if (destFile.exists() && destFile.isDirectory()) {
            throw new MojoExecutionException(destFile + " is a directory.");
        }
        if (destFile.exists() && !destFile.canWrite()) {
            throw new MojoExecutionException(destFile + " is not writable.");
        }
        this.getLog().info((CharSequence)("Creating combined yaml file " + destFile.getAbsolutePath()));
        if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            throw new MojoExecutionException("Unable to create directory or parent directory of " + destFile);
        }
        if (destFile.exists() && !destFile.delete()) {
            throw new MojoExecutionException("Unable to delete existing file " + destFile);
        }
        DirectoryScanner scanner = this.scan(this.fileset);
        String[] files = scanner.getIncludedFiles();
        FileOutputStream fos = null;
        try {
            YamlCombiner sc = new YamlCombiner();
            sc.setRelativeDir(new File(this.fileset.getDirectory()));
            sc.setFiles(files);
            sc.setLog(this.getLog());
            sc.setVerbose(this.verbose);
            fos = new FileOutputStream(destFile);
            if (this.filtering) {
                MavenResourcesExecution mre = new MavenResourcesExecution();
                mre.setMavenProject(this.project);
                mre.setFileFilters(null);
                mre.setEscapeWindowsPaths(true);
                mre.setMavenSession(this.session);
                mre.setInjectProjectBuildFilters(true);
                ConsoleLoggerManager clm = new ConsoleLoggerManager();
                Logger logger = clm.getLoggerForComponent("YamlCombineMojo");
                DefaultMavenFileFilter dmff = new DefaultMavenFileFilter(this.buildContext);
                this.getLog().info((CharSequence)("logger is " + logger));
                try {
                    List filterWrappers = dmff.getDefaultFilterWrappers((AbstractMavenFilteringRequest)mre);
                    sc.setFilterWrappers(filterWrappers);
                }
                catch (MavenFilteringException e) {
                    throw new IllegalStateException("Coult not get default filter wrappers", e);
                }
            }
            PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)fos, outputFileCharset));
            sc.combine(w, inputFileSetCharset);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not create combined yaml file", (Exception)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException("IOException closing file", ioe);
                }
            }
        }
        return destFile;
    }

    public void execute() throws MojoExecutionException {
        this.createCombinedYaml();
    }

    protected Boolean getFiltering() {
        return this.filtering;
    }

    protected Boolean getVerbose() {
        return this.verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

