/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.io;

import com.rapid7.client.dcerpc.io.PrimitiveOutput;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import java.io.IOException;
import java.io.OutputStream;

public class PacketOutput
extends PrimitiveOutput {
    private int referentID = 131072;

    public PacketOutput(OutputStream outputStream) {
        super(outputStream);
    }

    public <T extends Marshallable> T writeMarshallable(T marshallable) throws IOException {
        marshallable.marshalPreamble(this);
        marshallable.marshalEntity(this);
        marshallable.marshalDeferrals(this);
        return marshallable;
    }

    public void writeReferentID() throws IOException {
        int referentID = this.referentID;
        this.referentID += 4;
        this.writeInt(referentID);
    }

    public boolean writeReferentID(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
            return false;
        }
        this.writeReferentID();
        return true;
    }

    public void writeNull() throws IOException {
        this.writeInt(0);
    }

    public void writeEmptyCVArray(int maximumCount) throws IOException {
        this.writeInt(maximumCount);
        this.writeInt(0);
        this.writeInt(0);
    }

    public void writeEmptyRPCUnicodeString(int maximumChars) throws IOException {
        this.writeShort(0);
        this.writeShort((short)maximumChars << 1);
        this.writeReferentID();
        this.writeInt(maximumChars);
        this.writeInt(0);
        this.writeInt(0);
    }
}

