/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.messages;

import com.rapid7.client.dcerpc.Header;
import com.rapid7.client.dcerpc.PDUType;
import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import java.io.IOException;

public final class BindResponse
extends Header {
    private short maxXmitFrag;
    private short maxRecvFrag;

    public boolean isACK() {
        return PDUType.BIND_ACK.equals((Object)this.getPDUType());
    }

    public boolean isNAK() {
        return PDUType.BIND_NAK.equals((Object)this.getPDUType());
    }

    public short getMaxXmitFrag() {
        return this.maxXmitFrag;
    }

    public short getMaxRecvFrag() {
        return this.maxRecvFrag;
    }

    public void setMaxXmitFrag(short maxXmitFrag) {
        this.maxXmitFrag = maxXmitFrag;
    }

    public void setMaxRecvFrag(short maxRecvFrag) {
        this.maxRecvFrag = maxRecvFrag;
    }

    @Override
    public void marshal(PacketOutput packetOut) throws IOException {
        switch (this.getPDUType()) {
            case BIND_ACK: {
                this.setFragLength((short)20);
                super.marshal(packetOut);
                packetOut.writeShort(this.maxXmitFrag);
                packetOut.writeShort(this.maxRecvFrag);
                break;
            }
            case BIND_NAK: {
                this.setFragLength((short)16);
                super.marshal(packetOut);
                break;
            }
            default: {
                throw new IOException("Invalid PDU type: " + (Object)((Object)this.getPDUType()));
            }
        }
    }

    @Override
    public void unmarshal(PacketInput packetIn) throws IOException {
        super.unmarshal(packetIn);
        switch (this.getPDUType()) {
            case BIND_ACK: {
                this.maxXmitFrag = packetIn.readShort();
                this.maxRecvFrag = packetIn.readShort();
                packetIn.fullySkipBytes(this.getFragLength() - 20);
                break;
            }
            case BIND_NAK: {
                packetIn.fullySkipBytes(this.getFragLength() - 16);
                break;
            }
            default: {
                throw new IOException("Invalid PDU type: " + (Object)((Object)this.getPDUType()));
            }
        }
    }
}

