/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTranslatedName;
import java.io.IOException;
import java.util.Arrays;

public class LSAPRTranslatedNames
implements Unmarshallable {
    private LSAPRTranslatedName[] names;

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int entries = in.readInt();
        this.names = in.readReferentID() != 0 ? new LSAPRTranslatedName[entries] : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.names != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.names.length; ++i) {
                LSAPRTranslatedName lsaprTranslatedName = new LSAPRTranslatedName();
                lsaprTranslatedName.unmarshalPreamble(in);
                this.names[i] = lsaprTranslatedName;
            }
            for (LSAPRTranslatedName lsaprTranslatedName : this.names) {
                lsaprTranslatedName.unmarshalEntity(in);
            }
            for (LSAPRTranslatedName lsaprTranslatedName : this.names) {
                lsaprTranslatedName.unmarshalDeferrals(in);
            }
        }
    }

    public LSAPRTranslatedName[] getNames() {
        return this.names;
    }

    public int hashCode() {
        return Arrays.hashCode(this.names);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRTranslatedNames)) {
            return false;
        }
        return Arrays.equals(this.names, ((LSAPRTranslatedNames)obj).names);
    }

    public String toString() {
        return String.format("LSAPR_TRANSLATED_NAMES{Names:%s}", Arrays.toString(this.names));
    }
}

