/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msrrp.dto;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class FileTime {
    private final Date date;
    private final long windowsTime;

    public FileTime(long windowsTime) {
        if (windowsTime < 116444736000000000L) {
            throw new IllegalArgumentException("WindowsTime is invalid: " + windowsTime + " < 116444736000000000");
        }
        this.date = new Date((windowsTime - 116444736000000000L) / 10000L);
        this.windowsTime = windowsTime;
    }

    public Date getTime() {
        return this.date;
    }

    public long getWindowsTime() {
        return this.windowsTime;
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.format("%s (%d)", format.format(this.date), this.windowsTime);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.windowsTime);
    }

    public boolean equals(Object anObject) {
        return anObject instanceof FileTime && Objects.equals(this.date, ((FileTime)anObject).date) && Objects.equals(this.windowsTime, ((FileTime)anObject).windowsTime);
    }
}

