/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.messages;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mssamr.objects.DisplayInformationClass;
import com.rapid7.client.dcerpc.mssamr.objects.SAMPRDomainDisplayGroupBuffer;
import java.io.IOException;
import java.rmi.UnmarshalException;

public abstract class SamrQueryDisplayInformation2Response<T extends Unmarshallable>
extends RequestResponse {
    private int totalAvailable;
    private int totalReturnedBytes;
    private T displayInformation;

    public abstract DisplayInformationClass getDisplayInformationClass();

    abstract T createDisplayInformation();

    public T getDisplayInformation() {
        return this.displayInformation;
    }

    public int getTotalAvailable() {
        return this.totalAvailable;
    }

    public int getTotalReturned() {
        return this.totalReturnedBytes;
    }

    @Override
    public void unmarshalResponse(PacketInput packetIn) throws IOException {
        this.totalAvailable = packetIn.readInt();
        this.totalReturnedBytes = packetIn.readInt();
        int infoLevel = packetIn.readUnsignedShort();
        if (infoLevel != this.getDisplayInformationClass().getInfoLevel()) {
            throw new UnmarshalException(String.format("Incoming DISPLAY_INFORMATION_CLASS %d does not match expected: %d", infoLevel, this.getDisplayInformationClass().getInfoLevel()));
        }
        this.displayInformation = this.createDisplayInformation();
        packetIn.readUnmarshallable(this.displayInformation);
    }

    public static class DomainDisplayGroup
    extends SamrQueryDisplayInformation2Response<SAMPRDomainDisplayGroupBuffer> {
        @Override
        public DisplayInformationClass getDisplayInformationClass() {
            return DisplayInformationClass.DomainDisplayGroup;
        }

        @Override
        SAMPRDomainDisplayGroupBuffer createDisplayInformation() {
            return new SAMPRDomainDisplayGroupBuffer();
        }
    }
}

