/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs;

import com.hierynomus.protocol.transport.TransportException;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo0;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo1;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo2;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo501;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo502;
import com.rapid7.client.dcerpc.mssrvs.dto.NetShareInfo503;
import com.rapid7.client.dcerpc.mssrvs.messages.NetprPathCanonicalizeRequest;
import com.rapid7.client.dcerpc.mssrvs.messages.NetrShareEnumRequest;
import com.rapid7.client.dcerpc.mssrvs.messages.NetrShareEnumResponse;
import com.rapid7.client.dcerpc.mssrvs.messages.NetrShareGetInfoRequest;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareEnumStruct;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo0;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo1;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo2;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo501;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo502;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo503;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfoContainer;
import com.rapid7.client.dcerpc.objects.WChar;
import com.rapid7.client.dcerpc.service.Service;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;

public class ServerService
extends Service {
    private static final int MAX_BUFFER_SIZE = 0x100000;

    public ServerService(RPCTransport transport) {
        super(transport);
    }

    public String getCanonicalizedName(String serverName, String pathName, String prefix, int outBufLength, int pathType, int flags) throws IOException {
        NetprPathCanonicalizeRequest request = new NetprPathCanonicalizeRequest(this.parseWCharNT(serverName), this.parseWCharNT(pathName, false), outBufLength, this.parseWCharNT(prefix, false), pathType, flags);
        return this.callExpectSuccess(request, "NetprPathCanonicalize").getOutBuf();
    }

    public NetShareInfo0 getShare0(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest0 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest0(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo0(this.callExpectSuccess(request, "NetrShareGetInfo[0]").getShareInfo());
    }

    public NetShareInfo1 getShare1(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest1 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest1(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo1(this.callExpectSuccess(request, "NetrShareGetInfo[1]").getShareInfo());
    }

    public NetShareInfo2 getShare2(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest2 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest2(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo2(this.callExpectSuccess(request, "NetrShareGetInfo[2]").getShareInfo());
    }

    public NetShareInfo501 getShare501(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest501 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest501(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo501(this.callExpectSuccess(request, "NetrShareGetInfo[501]").getShareInfo());
    }

    public NetShareInfo502 getShare502(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest502 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest502(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo502(this.callExpectSuccess(request, "NetrShareGetInfo[502]").getShareInfo());
    }

    public NetShareInfo503 getShare503(String shareName) throws IOException {
        NetrShareGetInfoRequest.NetrShareGetInfoRequest503 request = new NetrShareGetInfoRequest.NetrShareGetInfoRequest503(WChar.NullTerminated.of(shareName));
        return this.parseShareInfo503(this.callExpectSuccess(request, "NetrShareGetInfo[503]").getShareInfo());
    }

    public List<NetShareInfo0> getShares0() throws IOException {
        return new GetSharesRequest0(0x100000L).call().getShares();
    }

    public List<NetShareInfo1> getShares1() throws IOException {
        return new GetSharesRequest1(0x100000L).call().getShares();
    }

    public List<NetShareInfo2> getShares2() throws IOException {
        return new GetSharesRequest2(0x100000L).call().getShares();
    }

    public List<NetShareInfo501> getShares501() throws IOException {
        return new GetSharesRequest501(0x100000L).call().getShares();
    }

    public List<NetShareInfo502> getShares502() throws IOException {
        return new GetSharesRequest502(0x100000L).call().getShares();
    }

    public List<NetShareInfo503> getShares503() throws IOException {
        return new GetSharesRequest503(0x100000L).call().getShares();
    }

    private NetShareInfo0 parseShareInfo0(ShareInfo0 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo0(this.parseWChar(obj.getNetName()));
    }

    private NetShareInfo1 parseShareInfo1(ShareInfo1 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo1(this.parseWChar(obj.getNetName()), obj.getType(), this.parseWChar(obj.getRemark()));
    }

    private NetShareInfo2 parseShareInfo2(ShareInfo2 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo2(this.parseWChar(obj.getNetName()), obj.getType(), this.parseWChar(obj.getRemark()), obj.getPermissions(), obj.getMaxUses(), obj.getCurrentUses(), this.parseWChar(obj.getPath()), this.parseWChar(obj.getPasswd()));
    }

    private NetShareInfo501 parseShareInfo501(ShareInfo501 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo501(this.parseWChar(obj.getNetName()), obj.getType(), this.parseWChar(obj.getRemark()), obj.getFlags());
    }

    private NetShareInfo502 parseShareInfo502(ShareInfo502 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo502(this.parseWChar(obj.getNetName()), obj.getType(), this.parseWChar(obj.getRemark()), obj.getPermissions(), obj.getMaxUses(), obj.getCurrentUses(), this.parseWChar(obj.getPath()), this.parseWChar(obj.getPasswd()), obj.getSecurityDescriptor());
    }

    private NetShareInfo503 parseShareInfo503(ShareInfo503 obj) {
        if (obj == null) {
            return null;
        }
        return new NetShareInfo503(this.parseWChar(obj.getNetName()), obj.getType(), this.parseWChar(obj.getRemark()), obj.getPermissions(), obj.getMaxUses(), obj.getCurrentUses(), this.parseWChar(obj.getPath()), this.parseWChar(obj.getPasswd()), this.parseWChar(obj.getServerName()), obj.getSecurityDescriptor());
    }

    private abstract class GetSharesRequest<S extends ShareInfo, N extends NetShareInfo> {
        private final long preferredMaximumLength;
        private final List<N> shares;

        GetSharesRequest(long preferredMaximumLength) {
            this.preferredMaximumLength = preferredMaximumLength;
            this.shares = new ArrayList<N>();
        }

        List<N> getShares() {
            return this.shares;
        }

        abstract String getName();

        abstract N convert(S var1);

        abstract NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<S>>> createRequest(long var1, Long var3);

        GetSharesRequest<S, N> call() throws IOException {
            MutableLong resumeHandle = new MutableLong();
            while (true) {
                ShareInfo[] buffer;
                Object shareInfoContainer;
                NetrShareEnumRequest<ShareEnumStruct<ShareInfoContainer<S>>> request;
                NetrShareEnumResponse response;
                Object shareEnumStruct;
                if ((shareEnumStruct = (response = (NetrShareEnumResponse)ServerService.this.callExpect(request = this.createRequest(this.preferredMaximumLength, resumeHandle.getValue()), this.getName(), new SystemErrorCode[]{SystemErrorCode.ERROR_MORE_DATA, SystemErrorCode.ERROR_SUCCESS})).getShareEnumStruct()) != null && (shareInfoContainer = ((ShareEnumStruct)shareEnumStruct).getShareInfoContainer()) != null && (buffer = shareInfoContainer.getBuffer()) != null) {
                    for (ShareInfo src : buffer) {
                        this.shares.add(this.convert(src));
                    }
                }
                if (SystemErrorCode.ERROR_SUCCESS.is(response.getReturnValue())) {
                    return this;
                }
                Long responseResumeHandle = response.getResumeHandle();
                if (responseResumeHandle == null) {
                    throw new TransportException("NetrShareEnum resume handle null.");
                }
                if (responseResumeHandle.longValue() == resumeHandle.getValue().longValue()) {
                    throw new TransportException("NetrShareEnum resume handle not updated.");
                }
                resumeHandle.add((Number)responseResumeHandle);
            }
        }
    }

    private class GetSharesRequest503
    extends GetSharesRequest<ShareInfo503, NetShareInfo503> {
        GetSharesRequest503(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[503]";
        }

        @Override
        NetShareInfo503 convert(ShareInfo503 src) {
            return ServerService.this.parseShareInfo503(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo503>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest503(preferredMaximumLength, resumeHandle);
        }
    }

    private class GetSharesRequest502
    extends GetSharesRequest<ShareInfo502, NetShareInfo502> {
        GetSharesRequest502(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[502]";
        }

        @Override
        NetShareInfo502 convert(ShareInfo502 src) {
            return ServerService.this.parseShareInfo502(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo502>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest502(preferredMaximumLength, resumeHandle);
        }
    }

    private class GetSharesRequest501
    extends GetSharesRequest<ShareInfo501, NetShareInfo501> {
        GetSharesRequest501(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[501]";
        }

        @Override
        NetShareInfo501 convert(ShareInfo501 src) {
            return ServerService.this.parseShareInfo501(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo501>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest501(preferredMaximumLength, resumeHandle);
        }
    }

    private class GetSharesRequest2
    extends GetSharesRequest<ShareInfo2, NetShareInfo2> {
        GetSharesRequest2(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[2]";
        }

        @Override
        NetShareInfo2 convert(ShareInfo2 src) {
            return ServerService.this.parseShareInfo2(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo2>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest2(preferredMaximumLength, resumeHandle);
        }
    }

    private class GetSharesRequest1
    extends GetSharesRequest<ShareInfo1, NetShareInfo1> {
        GetSharesRequest1(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[1]";
        }

        @Override
        NetShareInfo1 convert(ShareInfo1 src) {
            return ServerService.this.parseShareInfo1(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo1>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest1(preferredMaximumLength, resumeHandle);
        }
    }

    private class GetSharesRequest0
    extends GetSharesRequest<ShareInfo0, NetShareInfo0> {
        GetSharesRequest0(long preferredMaximumLength) {
            super(preferredMaximumLength);
        }

        @Override
        String getName() {
            return "NetrShareEnum[0]";
        }

        @Override
        NetShareInfo0 convert(ShareInfo0 src) {
            return ServerService.this.parseShareInfo0(src);
        }

        @Override
        NetrShareEnumRequest<? extends ShareEnumStruct<? extends ShareInfoContainer<ShareInfo0>>> createRequest(long preferredMaximumLength, Long resumeHandle) {
            return new NetrShareEnumRequest.NetShareEnumRequest0(preferredMaximumLength, resumeHandle);
        }
    }
}

