/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo2;
import com.rapid7.client.dcerpc.objects.WChar;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import java.util.Objects;

public class ShareInfo503
extends ShareInfo2 {
    private WChar.NullTerminated serverName;
    private byte[] securityDescriptor;

    public WChar.NullTerminated getServerName() {
        return this.serverName;
    }

    public void setServerName(WChar.NullTerminated serverName) {
        this.serverName = serverName;
    }

    public byte[] getSecurityDescriptor() {
        return this.securityDescriptor;
    }

    public void setSecurityDescriptor(byte[] securityDescriptor) {
        this.securityDescriptor = securityDescriptor;
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        super.unmarshalEntity(in);
        this.serverName = in.readReferentID() != 0 ? new WChar.NullTerminated() : null;
        int reserved = this.readIndex("reserved", in);
        if (in.readReferentID() != 0) {
            if (reserved < 0) {
                throw new UnmarshalException(String.format("Expected reserved >= 0, got: %d", reserved));
            }
            this.securityDescriptor = new byte[reserved];
        } else {
            this.securityDescriptor = null;
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        super.unmarshalDeferrals(in);
        if (this.serverName != null) {
            in.readUnmarshallable(this.serverName);
        }
        if (this.securityDescriptor != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            in.readRawBytes(this.securityDescriptor);
        }
    }

    @Override
    public int hashCode() {
        int ret = super.hashCode();
        ret = ret * 31 + Objects.hash(this.getServerName());
        return ret * 31 + Arrays.hashCode(this.getSecurityDescriptor());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShareInfo503)) {
            return false;
        }
        ShareInfo503 other = (ShareInfo503)obj;
        return super.equals(obj) && Objects.equals(this.getServerName(), other.getServerName()) && Arrays.equals(this.getSecurityDescriptor(), other.getSecurityDescriptor());
    }

    @Override
    public String toString() {
        return String.format("SHARE_INFO_503{shi503_netname: %s, shi503_type: %d, shi503_remark: %s, shi503_permissions: %d, shi503_max_uses: %d, shi503_current_uses: %d, shi503_path: %s, shi503_passwd: %s, shi503_server_name: %s, size(shi503_security_descriptor): %s}", this.getNetName(), this.getType(), this.getRemark(), this.getPermissions(), this.getMaxUses(), this.getCurrentUses(), this.getPath(), this.getPasswd(), this.getServerName(), this.getSecurityDescriptor() == null ? "null" : Integer.valueOf(this.getSecurityDescriptor().length));
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

