/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl.dto;

import com.rapid7.client.dcerpc.msvcctl.dto.IServiceStatusInfo;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceStatusType;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServiceType;
import com.rapid7.client.dcerpc.msvcctl.dto.enums.ServicesAcceptedControls;
import java.util.Objects;

public class ServiceStatusInfo
implements IServiceStatusInfo {
    private final ServiceType serviceType;
    private final ServiceStatusType currentState;
    private final ServicesAcceptedControls controlsAccepted;
    private final int win32ExitCode;
    private final int serviceSpecificExitCode;
    private final int checkPoint;
    private final int waitHint;

    public ServiceStatusInfo(ServiceType serviceType, ServiceStatusType currentState, ServicesAcceptedControls controlsAccepted, int win32ExitCode, int serviceSpecificExitCode, int checkPoint, int waitHint) {
        this.serviceType = serviceType;
        this.currentState = currentState;
        this.controlsAccepted = controlsAccepted;
        this.win32ExitCode = win32ExitCode;
        this.serviceSpecificExitCode = serviceSpecificExitCode;
        this.checkPoint = checkPoint;
        this.waitHint = waitHint;
    }

    @Override
    public ServiceType getServiceType() {
        return this.serviceType;
    }

    @Override
    public ServiceStatusType getCurrentState() {
        return this.currentState;
    }

    @Override
    public ServicesAcceptedControls getControlsAccepted() {
        return this.controlsAccepted;
    }

    @Override
    public int getWin32ExitCode() {
        return this.win32ExitCode;
    }

    @Override
    public int getServiceSpecificExitCode() {
        return this.serviceSpecificExitCode;
    }

    @Override
    public int getCheckPoint() {
        return this.checkPoint;
    }

    @Override
    public int getWaitHint() {
        return this.waitHint;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IServiceStatusInfo)) {
            return false;
        }
        IServiceStatusInfo other = (IServiceStatusInfo)obj;
        return this.getServiceType() == other.getServiceType() && this.getCurrentState() == other.getCurrentState() && this.getControlsAccepted() == other.getControlsAccepted() && this.getWin32ExitCode() == other.getWin32ExitCode() && this.getServiceSpecificExitCode() == other.getServiceSpecificExitCode() && this.getCheckPoint() == other.getCheckPoint() && this.getWaitHint() == other.getWaitHint();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getServiceType(), this.getCurrentState(), this.getControlsAccepted(), this.getWin32ExitCode(), this.getServiceSpecificExitCode(), this.getCheckPoint(), this.getWaitHint()});
    }

    public String toString() {
        return String.format("ServiceStatusInfo{serviceType: %s, currentState: %s, controlsAccepted: %s, win32ExitCode: %d, serviceSpecificExitCode: %d, checkPoint: %d, waitHint: %d}", new Object[]{this.getServiceType(), this.getCurrentState(), this.getControlsAccepted(), this.getWin32ExitCode(), this.getServiceSpecificExitCode(), this.getCheckPoint(), this.getWaitHint()});
    }
}

