/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.service;

import com.rapid7.client.dcerpc.RPCException;
import com.rapid7.client.dcerpc.dto.ContextHandle;
import com.rapid7.client.dcerpc.dto.SID;
import com.rapid7.client.dcerpc.messages.RequestCall;
import com.rapid7.client.dcerpc.messages.RequestResponse;
import com.rapid7.client.dcerpc.mserref.SystemErrorCode;
import com.rapid7.client.dcerpc.objects.RPCSID;
import com.rapid7.client.dcerpc.objects.RPCUnicodeString;
import com.rapid7.client.dcerpc.objects.WChar;
import com.rapid7.client.dcerpc.transport.RPCTransport;
import java.io.IOException;

public abstract class Service {
    private final RPCTransport transport;

    protected Service(RPCTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Expecting non-null transport");
        }
        this.transport = transport;
    }

    protected <R extends RequestResponse> R call(RequestCall<R> request) throws IOException {
        return this.transport.call(request);
    }

    protected <R extends RequestResponse> R callExpectSuccess(RequestCall<R> request, String name) throws IOException {
        return this.callExpect(request, name, SystemErrorCode.ERROR_SUCCESS);
    }

    protected <R extends RequestResponse> R callExpect(RequestCall<R> request, String name, SystemErrorCode ... expectCodes) throws IOException {
        R response = this.call(request);
        if (expectCodes == null) {
            return response;
        }
        int returnValue = ((RequestResponse)response).getReturnValue();
        for (SystemErrorCode code : expectCodes) {
            if (code == null || !code.is(returnValue)) continue;
            return response;
        }
        throw new RPCException(name, returnValue);
    }

    protected RPCUnicodeString.NonNullTerminated[] parseNonNullTerminatedStrings(String[] strings) {
        if (strings == null) {
            return new RPCUnicodeString.NonNullTerminated[0];
        }
        RPCUnicodeString.NonNullTerminated[] ret = new RPCUnicodeString.NonNullTerminated[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            ret[i] = RPCUnicodeString.NonNullTerminated.of(strings[i]);
        }
        return ret;
    }

    protected String[] parseRPCUnicodeStrings(RPCUnicodeString ... rpcUnicodeStrings) {
        if (rpcUnicodeStrings == null) {
            return new String[0];
        }
        String[] ret = new String[rpcUnicodeStrings.length];
        for (int i = 0; i < rpcUnicodeStrings.length; ++i) {
            ret[i] = rpcUnicodeStrings[i] == null ? null : rpcUnicodeStrings[i].getValue();
        }
        return ret;
    }

    protected byte[] parseHandle(ContextHandle handle) {
        return handle.getBytes();
    }

    protected RPCSID parseSID(SID sid) {
        if (sid == null) {
            return null;
        }
        RPCSID rpcsid = new RPCSID();
        rpcsid.setRevision((char)sid.getRevision());
        rpcsid.setIdentifierAuthority(sid.getIdentifierAuthority());
        rpcsid.setSubAuthority(sid.getSubAuthorities());
        return rpcsid;
    }

    protected RPCSID[] parseSIDs(SID[] sids) {
        RPCSID[] rpcsids;
        if (sids == null) {
            rpcsids = new RPCSID[]{};
            sids = new SID[]{};
        } else {
            rpcsids = new RPCSID[sids.length];
        }
        for (int i = 0; i < rpcsids.length; ++i) {
            rpcsids[i] = this.parseSID(sids[i]);
        }
        return rpcsids;
    }

    protected SID[] parseRPCSIDs(RPCSID[] rpcsids) {
        SID[] sids;
        if (rpcsids == null) {
            sids = new SID[]{};
            rpcsids = new RPCSID[]{};
        } else {
            sids = new SID[rpcsids.length];
        }
        for (int i = 0; i < sids.length; ++i) {
            sids[i] = this.parseRPCSID(rpcsids[i]);
        }
        return sids;
    }

    protected SID parseRPCSID(RPCSID rpcsid) {
        return this.parseRPCSID(rpcsid, true);
    }

    protected SID parseRPCSID(RPCSID rpcsid, boolean nullable) {
        if (rpcsid == null && nullable) {
            return null;
        }
        return new SID((byte)rpcsid.getRevision(), rpcsid.getIdentifierAuthority(), rpcsid.getSubAuthority());
    }

    protected String parseRPCUnicodeString(RPCUnicodeString rpcUnicodeString) {
        return this.parseRPCUnicodeString(rpcUnicodeString, false);
    }

    protected String parseRPCUnicodeString(RPCUnicodeString rpcUnicodeString, boolean nullable) {
        if (rpcUnicodeString == null) {
            if (nullable) {
                return null;
            }
            throw new NullPointerException("Expecting non-null rpcUnicodeString");
        }
        return rpcUnicodeString.getValue();
    }

    protected WChar.NullTerminated parseWCharNT(String str) {
        return this.parseWCharNT(str, true);
    }

    protected WChar.NullTerminated parseWCharNT(String str, boolean nullable) {
        if (str == null && nullable) {
            return null;
        }
        return WChar.NullTerminated.of(str);
    }

    protected WChar.NonNullTerminated parseWChar(String str) {
        return this.parseWChar(str, true);
    }

    protected WChar.NonNullTerminated parseWChar(String str, boolean nullable) {
        if (str == null && nullable) {
            return null;
        }
        return WChar.NonNullTerminated.of(str);
    }

    protected String parseWChar(WChar wChar) {
        return this.parseWChar(wChar, true);
    }

    protected String parseWChar(WChar wChar, boolean nullable) {
        if (wChar == null && nullable) {
            return null;
        }
        return wChar.getValue();
    }
}

