/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.dto;

import com.google.common.io.BaseEncoding;
import java.util.Arrays;
import java.util.Objects;

public class ContextHandle {
    private final byte[] bytes;

    public ContextHandle(byte[] handle) {
        if (handle == null) {
            throw new IllegalArgumentException("Expecting non-null handle");
        }
        if (handle.length != 20) {
            throw new IllegalArgumentException(String.format("Expecting 20 entries in handle, got: %d", handle.length));
        }
        this.bytes = handle;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Objects.equals(this.getClass(), obj.getClass())) {
            return false;
        }
        return Arrays.equals(this.bytes, ((ContextHandle)obj).bytes);
    }

    public String toString() {
        StringBuilder handleStr = new StringBuilder();
        for (byte handleByte : this.bytes) {
            handleStr.append(String.format("%02X", handleByte));
        }
        return handleStr.toString();
    }

    public static ContextHandle fromHex(String hString) {
        byte[] bytes = new byte[20];
        if (hString == null || hString.length() > bytes.length * 2) {
            throw new IllegalArgumentException("hString is invalid: " + hString);
        }
        byte[] handle = BaseEncoding.base16().decode((CharSequence)hString.toUpperCase());
        int srcPos = 0;
        int index = 0;
        while (index < handle.length) {
            if (handle[index++] != 0) continue;
            srcPos = index;
        }
        int dstPos = bytes.length - handle.length + srcPos;
        int dstLen = handle.length - srcPos;
        System.arraycopy(handle, srcPos, bytes, dstPos, dstLen);
        return new ContextHandle(bytes);
    }
}

