/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class LSAPRPolicyAuditEventsInfo
implements Unmarshallable {
    private char auditingMode;
    private int[] eventAuditingOptions;
    private int maximumAuditEventCount;

    public char getAuditingMode() {
        return this.auditingMode;
    }

    public void setAuditingMode(char auditingMode) {
        this.auditingMode = auditingMode;
    }

    public int[] getEventAuditingOptions() {
        return this.eventAuditingOptions;
    }

    public void setEventAuditingOptions(int[] eventAuditingOptions) {
        this.eventAuditingOptions = eventAuditingOptions;
    }

    public int getMaximumAuditEventCount() {
        return this.maximumAuditEventCount;
    }

    public void setMaximumAuditEventCount(int maximumAuditEventCount) {
        this.maximumAuditEventCount = maximumAuditEventCount;
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        this.auditingMode = in.readUnsignedByte();
        in.fullySkipBytes(3);
        boolean eventAuditingOptionsNull = in.readReferentID() == 0;
        this.maximumAuditEventCount = in.readInt();
        if (eventAuditingOptionsNull) {
            if (this.maximumAuditEventCount != 0) {
                throw new IllegalArgumentException("If the MaximumAuditingEventCount field has a value other than 0, EventAuditingOptions MUST NOT be NULL.");
            }
            this.eventAuditingOptions = null;
        } else {
            this.eventAuditingOptions = new int[this.maximumAuditEventCount];
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.eventAuditingOptions != null) {
            in.align(Alignment.FOUR);
            int maximumCount = in.readInt();
            if (maximumCount < this.maximumAuditEventCount) {
                throw new IllegalArgumentException(String.format("Expected MaximumAuditingEventCount (%d) >= EventAuditingOptions.MaximumCount (%d)", maximumCount, this.maximumAuditEventCount));
            }
            for (int i = 0; i < this.eventAuditingOptions.length; ++i) {
                this.eventAuditingOptions[i] = in.readInt();
            }
        }
    }

    public int hashCode() {
        int result = Objects.hashCode(Character.valueOf(this.getAuditingMode()));
        result = 31 * result + Arrays.hashCode(this.getEventAuditingOptions());
        return 31 * result + Objects.hashCode(this.getMaximumAuditEventCount());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRPolicyAuditEventsInfo)) {
            return false;
        }
        LSAPRPolicyAuditEventsInfo other = (LSAPRPolicyAuditEventsInfo)obj;
        return Objects.equals(Character.valueOf(this.getAuditingMode()), Character.valueOf(other.getAuditingMode())) && Arrays.equals(this.getEventAuditingOptions(), other.getEventAuditingOptions()) && Objects.equals(this.getMaximumAuditEventCount(), other.getMaximumAuditEventCount());
    }

    public String toString() {
        return String.format("LSAPR_POLICY_AUDIT_EVENTS_INFO{AuditingMode:%d, EventAuditingOptions:%s, MaximumAuditEventCount:%d}", this.getAuditingMode(), Arrays.toString(this.getEventAuditingOptions()), this.getMaximumAuditEventCount());
    }
}

