/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mslsad.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.mslsad.objects.LSAPRTrustInformation;
import java.io.IOException;
import java.util.Arrays;

public class LSAPRReferencedDomainList
implements Unmarshallable {
    private LSAPRTrustInformation[] domains;

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int entries = in.readInt();
        this.domains = in.readReferentID() != 0 ? new LSAPRTrustInformation[entries] : null;
        in.fullySkipBytes(4);
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.domains != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.domains.length; ++i) {
                LSAPRTrustInformation lsaprTrustInformation = new LSAPRTrustInformation();
                lsaprTrustInformation.unmarshalPreamble(in);
                this.domains[i] = lsaprTrustInformation;
            }
            for (LSAPRTrustInformation lsaprTrustInformation : this.domains) {
                lsaprTrustInformation.unmarshalEntity(in);
            }
            for (LSAPRTrustInformation lsaprTrustInformation : this.domains) {
                lsaprTrustInformation.unmarshalDeferrals(in);
            }
        }
    }

    public LSAPRTrustInformation[] getDomains() {
        return this.domains;
    }

    public int hashCode() {
        return Arrays.hashCode(this.domains);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LSAPRReferencedDomainList)) {
            return false;
        }
        return Arrays.equals(this.domains, ((LSAPRReferencedDomainList)obj).domains);
    }

    public String toString() {
        return String.format("LSAPRReferencedDomainList{domains:%s}", Arrays.toString(this.domains));
    }
}

