/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msrrp.dto;

import com.rapid7.client.dcerpc.msrrp.messages.HandleRequest;
import java.util.HashMap;
import java.util.Map;

public enum RegistryHive {
    HKEY_CLASSES_ROOT("HKEY_CLASSES_ROOT", "HKCR", "OpenClassesRoot", 0),
    HKEY_CURRENT_CONFIG("HKEY_CURRENT_CONFIG", "HKCC", "OpenCurrentConfig", 27),
    HKEY_CURRENT_USER("HKEY_CURRENT_USER", "HKCU", "OpenCurrentUser", 1),
    HKEY_LOCAL_MACHINE("HKEY_LOCAL_MACHINE", "HKLM", "OpenLocalMachine", 2),
    HKEY_PERFORMANCE_DATA("HKEY_PERFORMANCE_DATA", "", "OpenPerformanceData", 3),
    HKEY_PERFORMANCE_NLSTEXT("HKEY_PERFORMANCE_NLSTEXT", "", "OpenPerformanceNlsText", 33),
    HKEY_PERFORMANCE_TEXT("HKEY_PERFORMANCE_TEXT", "", "OpenPerformanceText", 32),
    HKEY_USERS("HKEY_USERS", "HKU", "OpenUsers", 4);

    private final String fullName;
    private final String shortName;
    private final String opName;
    private final short opNum;
    private static final Map<String, RegistryHive> registryHiveByName;

    private RegistryHive(String fullName, String shortName, String opName, short opNum) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.opName = opName;
        this.opNum = opNum;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getOpName() {
        return this.opName;
    }

    public short getOpNum() {
        return this.opNum;
    }

    public HandleRequest getRequest(int accessMask) {
        return new HandleRequest(this.opNum, accessMask);
    }

    public static RegistryHive getRegistryHiveByName(String fullName) {
        return registryHiveByName.get(fullName.trim().toUpperCase());
    }

    static {
        registryHiveByName = new HashMap<String, RegistryHive>();
        for (RegistryHive hive : RegistryHive.values()) {
            String fullName = hive.getFullName();
            registryHiveByName.put(fullName, hive);
            String shortName = hive.getShortName();
            if (shortName.isEmpty()) continue;
            registryHiveByName.put(shortName, hive);
        }
    }
}

