/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msrrp.dto;

import com.google.common.io.BaseEncoding;
import com.rapid7.client.dcerpc.msrrp.dto.RegistryValueType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import javax.activation.UnsupportedDataTypeException;
import org.apache.commons.lang3.ArrayUtils;

public class RegistryValue {
    private final String name;
    private final RegistryValueType type;
    private final byte[] data;

    public RegistryValue(String name, RegistryValueType type, byte[] data) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name is invalid: " + name);
        }
        if (type == null) {
            throw new IllegalArgumentException("Type is invalid: " + (Object)((Object)type));
        }
        if (data == null) {
            throw new IllegalArgumentException("Data is invalid: " + data);
        }
        this.name = name;
        this.type = type;
        switch (type) {
            case REG_DWORD: 
            case REG_DWORD_BIG_ENDIAN: {
                if (data.length == 4) break;
                throw new IOException(String.format("Data type %s is invalid with length %d: 0x%s,", new Object[]{type, data.length, BaseEncoding.base16().encode(data)}));
            }
            case REG_QWORD: {
                if (data.length == 8) break;
                throw new IOException(String.format("Data type %s is invalid with length %d: 0x%s,", new Object[]{type, data.length, BaseEncoding.base16().encode(data)}));
            }
            case REG_EXPAND_SZ: 
            case REG_LINK: 
            case REG_SZ: 
            case REG_MULTI_SZ: {
                if ((data.length & 1) == 0) break;
                throw new IOException(String.format("Data type %s is invalid with length %d: 0x%s,", new Object[]{type, data.length, BaseEncoding.base16().encode(data)}));
            }
        }
        switch (type) {
            case REG_DWORD: 
            case REG_QWORD: {
                this.data = Arrays.copyOf(data, data.length);
                ArrayUtils.reverse((byte[])this.data);
                break;
            }
            default: {
                this.data = Arrays.copyOf(data, data.length);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public RegistryValueType getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataAsInt() {
        switch (this.type) {
            case REG_DWORD: 
            case REG_DWORD_BIG_ENDIAN: {
                return new BigInteger(1, this.data).intValue();
            }
        }
        throw new IllegalStateException();
    }

    public long getDataAsLong() {
        switch (this.type) {
            case REG_DWORD: 
            case REG_DWORD_BIG_ENDIAN: 
            case REG_QWORD: {
                return new BigInteger(1, this.data).longValue();
            }
        }
        throw new IllegalStateException();
    }

    public String getDataAsBinaryStr() {
        StringBuilder text = new StringBuilder();
        for (byte byteValue : this.data) {
            for (int bitIndex = 7; bitIndex >= 0; --bitIndex) {
                int bitValue = byteValue >> bitIndex & 1;
                text.append(bitValue);
            }
        }
        return text.toString();
    }

    public String getDataAsHexStr() {
        return BaseEncoding.base16().encode(this.data);
    }

    public String[] getDataAsMultiStr() throws UnsupportedEncodingException {
        switch (this.type) {
            case REG_MULTI_SZ: {
                int nullIndex;
                StringBuilder element = new StringBuilder();
                LinkedList<String> elements = new LinkedList<String>();
                ByteBuffer dataBuffer = ByteBuffer.wrap(this.data);
                dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                while (dataBuffer.hasRemaining()) {
                    short shortValue = dataBuffer.getShort();
                    if (shortValue == 0) {
                        elements.add(element.toString());
                        element.setLength(0);
                        continue;
                    }
                    element.append((char)shortValue);
                }
                if (0 < element.length()) {
                    elements.add(element.toString());
                    element.setLength(0);
                }
                if (0 < elements.size() && ((String)elements.get(nullIndex = elements.size() - 1)).isEmpty()) {
                    elements.remove(nullIndex);
                }
                return elements.toArray(new String[elements.size()]);
            }
        }
        throw new IllegalStateException();
    }

    public String getDataAsStr() throws UnsupportedEncodingException, UnsupportedDataTypeException {
        StringBuilder repr = new StringBuilder();
        switch (this.type) {
            case REG_BINARY: 
            case REG_NONE: {
                repr.append(this.getDataAsBinaryStr());
                break;
            }
            case REG_DWORD: 
            case REG_DWORD_BIG_ENDIAN: {
                repr.append(this.getDataAsInt());
                break;
            }
            case REG_QWORD: {
                repr.append(this.getDataAsLong());
                break;
            }
            case REG_EXPAND_SZ: 
            case REG_LINK: 
            case REG_SZ: {
                short shortValue;
                ByteBuffer dataBuffer = ByteBuffer.wrap(this.data);
                dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
                while (dataBuffer.hasRemaining() && (shortValue = dataBuffer.getShort()) != 0) {
                    repr.append((char)shortValue);
                }
                break;
            }
            case REG_MULTI_SZ: {
                StringBuilder multiRepr = new StringBuilder();
                for (String element : this.getDataAsMultiStr()) {
                    if (0 < multiRepr.length()) {
                        multiRepr.append(", ");
                    }
                    multiRepr.append("\"");
                    multiRepr.append(element.replace("\"", "\\\""));
                    multiRepr.append("\"");
                }
                if (0 >= multiRepr.length()) break;
                repr.append("{");
                repr.append(multiRepr.toString());
                repr.append("}");
                break;
            }
            default: {
                throw new UnsupportedDataTypeException();
            }
        }
        return repr.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append(" ");
        result.append("(");
        result.append((Object)this.type);
        result.append(")");
        try {
            String value = this.getDataAsStr();
            if (!value.isEmpty()) {
                result.append(" = ");
                result.append(this.getDataAsStr());
                result.append(" (0x");
                result.append(this.getDataAsHexStr());
                result.append(")");
            }
        }
        catch (UnsupportedEncodingException | UnsupportedDataTypeException exception) {
            result.append(" ! ");
            result.append(exception.getClass().getName());
            result.append("::");
            result.append(exception.getLocalizedMessage());
        }
        return result.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, Arrays.hashCode(this.data)});
    }

    public boolean equals(Object anObject) {
        return anObject instanceof RegistryValue && Objects.equals(this.name, ((RegistryValue)anObject).name) && Objects.equals((Object)this.type, (Object)((RegistryValue)anObject).type) && Arrays.equals(this.data, ((RegistryValue)anObject).data);
    }
}

