/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msrrp.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import java.io.IOException;
import java.rmi.UnmarshalException;

public class RPCSecurityDescriptor
implements Unmarshallable,
Marshallable {
    private int cbInSecurityDescriptor;
    private byte[] lpSecurityDescriptor;

    public byte[] getLpSecurityDescriptor() {
        return this.lpSecurityDescriptor;
    }

    public void setLpSecurityDescriptor(byte[] lpSecurityDescriptor) {
        this.lpSecurityDescriptor = lpSecurityDescriptor;
    }

    public void setCbInSecurityDescriptor(int cbInSecurityDescriptor) {
        this.cbInSecurityDescriptor = cbInSecurityDescriptor;
    }

    @Override
    public void unmarshalPreamble(PacketInput in) {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        boolean lpSecurityDescriptorPresent = in.readReferentID() != 0;
        in.fullySkipBytes(4);
        int cbOutSecurityDescriptor = in.readIndex("cbOutSecurityDescriptor");
        this.lpSecurityDescriptor = (byte[])(lpSecurityDescriptorPresent ? new byte[cbOutSecurityDescriptor] : null);
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.lpSecurityDescriptor != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            int offset = in.readIndex("Offset");
            in.fullySkipBytes(offset);
            int actualCount = in.readIndex("ActualCount");
            if (actualCount != this.lpSecurityDescriptor.length) {
                throw new UnmarshalException(String.format("AcutalCount of the conformant varying array does not match cbOutSecurityDescriptor: %d != %d", actualCount, this.lpSecurityDescriptor.length));
            }
            in.readRawBytes(this.lpSecurityDescriptor);
        }
    }

    @Override
    public void marshalPreamble(PacketOutput out) {
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        out.writeReferentID(this.lpSecurityDescriptor);
        out.writeInt(this.cbInSecurityDescriptor);
        out.writeInt(0);
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
        if (this.lpSecurityDescriptor != null) {
            out.align(Alignment.FOUR);
            out.writeInt(this.cbInSecurityDescriptor);
            out.writeInt(0);
            out.writeInt(this.lpSecurityDescriptor.length);
            out.write(this.lpSecurityDescriptor);
        }
    }
}

