/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssamr.dto;

import java.util.Arrays;

public class LogonHours {
    private UnitsPerWeek unitsPerWeek;
    private byte[] logonHours;

    public LogonHours(byte[] logonHours) {
        if (logonHours == null) {
            throw new IllegalArgumentException("Expecting non-null logonHours");
        }
        this.unitsPerWeek = UnitsPerWeek.fromLogonHoursLength(logonHours.length);
        this.logonHours = logonHours;
    }

    public UnitsPerWeek getUnitsPerWeek() {
        return this.unitsPerWeek;
    }

    public byte[] getLogonHours() {
        return this.logonHours;
    }

    public int hashCode() {
        return Arrays.hashCode(this.logonHours);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogonHours)) {
            return false;
        }
        return Arrays.equals(this.logonHours, ((LogonHours)obj).logonHours);
    }

    public String toString() {
        return String.format("LogonHours{unitsPerWeek: %s, size(logonHours): %d", new Object[]{this.unitsPerWeek, this.logonHours.length});
    }

    public static enum UnitsPerWeek {
        DAYS,
        HOURS,
        MINUTES;


        public static UnitsPerWeek fromLogonHoursLength(int length) {
            switch (length) {
                case 1: {
                    return DAYS;
                }
                case 21: {
                    return HOURS;
                }
                case 1260: {
                    return MINUTES;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid logonHours length: %d", length));
        }
    }
}

