/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo2;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;

public class ShareInfo502
extends ShareInfo2 {
    private byte[] securityDescriptor;

    public byte[] getSecurityDescriptor() {
        return this.securityDescriptor;
    }

    public void setSecurityDescriptor(byte[] securityDescriptor) {
        this.securityDescriptor = securityDescriptor;
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        super.unmarshalEntity(in);
        int reserved = this.readIndex("reserved", in);
        if (in.readReferentID() != 0) {
            if (reserved < 0) {
                throw new UnmarshalException(String.format("Expected reserved >= 0, got: %d", reserved));
            }
            this.securityDescriptor = new byte[reserved];
        } else {
            this.securityDescriptor = null;
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        super.unmarshalDeferrals(in);
        if (this.securityDescriptor != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            in.readRawBytes(this.securityDescriptor);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + Arrays.hashCode(this.securityDescriptor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShareInfo502)) {
            return false;
        }
        ShareInfo502 other = (ShareInfo502)obj;
        return super.equals(obj) && Arrays.equals(this.securityDescriptor, other.securityDescriptor);
    }

    @Override
    public String toString() {
        return String.format("SHARE_INFO_502{shi502_netname: %s, shi502_type: %d, shi502_remark: %s, shi502_permissions: %d, shi502_max_uses: %d, shi502_current_uses: %d, shi502_path: %s, shi502_passwd: %s, size(shi502_security_descriptor): %s}", this.getNetName(), this.getType(), this.getRemark(), this.getPermissions(), this.getMaxUses(), this.getCurrentUses(), this.getPath(), this.getPasswd(), this.getSecurityDescriptor() == null ? "null" : Integer.valueOf(this.getSecurityDescriptor().length));
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }
}

