/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.mssrvs.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo0;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo1;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo2;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo501;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo502;
import com.rapid7.client.dcerpc.mssrvs.objects.ShareInfo503;
import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Arrays;

public abstract class ShareInfoContainer<T extends ShareInfo>
implements Unmarshallable {
    private T[] buffer;

    public T[] getBuffer() {
        return this.buffer;
    }

    abstract T[] createBuffer(int var1);

    abstract T createEntry();

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        int entriesRead = this.readIndex("EntriesRead", in);
        if (in.readReferentID() != 0) {
            if (entriesRead < 0) {
                throw new UnmarshalException(String.format("Expected entriesRead >= 0, got: %d", entriesRead));
            }
            this.buffer = this.createBuffer(entriesRead);
        } else {
            this.buffer = null;
        }
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.buffer != null) {
            in.align(Alignment.FOUR);
            in.fullySkipBytes(4);
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = this.createEntry();
                ((ShareInfo)this.buffer[i]).unmarshalPreamble(in);
            }
            for (T entry : this.buffer) {
                ((ShareInfo)entry).unmarshalEntity(in);
            }
            for (T entry : this.buffer) {
                ((ShareInfo)entry).unmarshalDeferrals(in);
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShareInfoContainer)) {
            return false;
        }
        return Arrays.equals(this.buffer, ((ShareInfoContainer)obj).buffer);
    }

    private int readIndex(String name, PacketInput in) throws IOException {
        long ret = in.readUnsignedInt();
        if (ret > Integer.MAX_VALUE) {
            throw new UnmarshalException(String.format("%s %d > %d", name, ret, Integer.MAX_VALUE));
        }
        return (int)ret;
    }

    public static class ShareInfo503Container
    extends ShareInfoContainer<ShareInfo503> {
        @Override
        ShareInfo503 createEntry() {
            return new ShareInfo503();
        }

        ShareInfo503[] createBuffer(int size) {
            return new ShareInfo503[size];
        }
    }

    public static class ShareInfo502Container
    extends ShareInfoContainer<ShareInfo502> {
        @Override
        ShareInfo502 createEntry() {
            return new ShareInfo502();
        }

        ShareInfo502[] createBuffer(int size) {
            return new ShareInfo502[size];
        }
    }

    public static class ShareInfo501Container
    extends ShareInfoContainer<ShareInfo501> {
        @Override
        ShareInfo501 createEntry() {
            return new ShareInfo501();
        }

        ShareInfo501[] createBuffer(int size) {
            return new ShareInfo501[size];
        }
    }

    public static class ShareInfo2Container
    extends ShareInfoContainer<ShareInfo2> {
        @Override
        ShareInfo2 createEntry() {
            return new ShareInfo2();
        }

        ShareInfo2[] createBuffer(int size) {
            return new ShareInfo2[size];
        }
    }

    public static class ShareInfo1Container
    extends ShareInfoContainer<ShareInfo1> {
        @Override
        ShareInfo1 createEntry() {
            return new ShareInfo1();
        }

        ShareInfo1[] createBuffer(int size) {
            return new ShareInfo1[size];
        }
    }

    public static class ShareInfo0Container
    extends ShareInfoContainer<ShareInfo0> {
        @Override
        ShareInfo0 createEntry() {
            return new ShareInfo0();
        }

        ShareInfo0[] createBuffer(int size) {
            return new ShareInfo0[size];
        }
    }
}

