/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.msvcctl.dto.enums;

import java.util.HashMap;
import java.util.Map;

public enum ServiceError {
    IGNORE(0),
    NORMAL(1),
    SEVERE(2),
    CRITICAL(3),
    NO_CHANGE(-1),
    UNKNOWN(-1);

    private final int m_value;
    private static final Map<Integer, ServiceError> MS_TYPEDMAP;

    private ServiceError(int value) {
        this.m_value = value;
    }

    public int getValue() {
        return this.m_value;
    }

    public static ServiceError fromInt(int value) {
        ServiceError type = MS_TYPEDMAP.get(value);
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    static {
        MS_TYPEDMAP = new HashMap<Integer, ServiceError>();
        for (ServiceError type : ServiceError.values()) {
            MS_TYPEDMAP.put(type.getValue(), type);
        }
    }
}

