/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.client.dcerpc.objects;

import com.rapid7.client.dcerpc.io.PacketInput;
import com.rapid7.client.dcerpc.io.PacketOutput;
import com.rapid7.client.dcerpc.io.ndr.Alignment;
import com.rapid7.client.dcerpc.io.ndr.Marshallable;
import com.rapid7.client.dcerpc.io.ndr.Unmarshallable;
import com.rapid7.client.dcerpc.objects.WChar;
import java.io.IOException;
import java.util.Objects;

public abstract class RPCUnicodeString
implements Unmarshallable,
Marshallable {
    private WChar wChar;

    abstract WChar createWChar();

    public String getValue() {
        if (this.wChar == null) {
            return null;
        }
        return this.wChar.getValue();
    }

    public void setValue(String value) {
        if (value == null) {
            this.wChar = null;
        } else {
            this.wChar = this.createWChar();
            this.wChar.setValue(value);
        }
    }

    @Override
    public void marshalPreamble(PacketOutput out) throws IOException {
    }

    @Override
    public void marshalEntity(PacketOutput out) throws IOException {
        out.align(Alignment.FOUR);
        if (this.wChar == null) {
            out.writeShort(0);
            out.writeShort(0);
        } else {
            int byteLength = 2 * this.wChar.getValue().length() + (this.wChar.isNullTerminated() ? 2 : 0);
            out.writeShort(byteLength);
            out.writeShort(byteLength);
        }
        out.writeReferentID(this.wChar);
    }

    @Override
    public void marshalDeferrals(PacketOutput out) throws IOException {
        if (this.wChar != null) {
            out.writeMarshallable(this.wChar);
        }
    }

    @Override
    public void unmarshalPreamble(PacketInput in) throws IOException {
    }

    @Override
    public void unmarshalEntity(PacketInput in) throws IOException {
        in.align(Alignment.FOUR);
        in.fullySkipBytes(2);
        in.fullySkipBytes(2);
        this.wChar = in.readReferentID() != 0 ? this.createWChar() : null;
    }

    @Override
    public void unmarshalDeferrals(PacketInput in) throws IOException {
        if (this.wChar != null) {
            in.readUnmarshallable(this.wChar);
        }
    }

    public int hashCode() {
        return Objects.hash(this.wChar);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RPCUnicodeString)) {
            return false;
        }
        return Objects.equals(this.wChar, ((RPCUnicodeString)obj).wChar);
    }

    public String toString() {
        return this.getValue() == null ? "null" : String.format("\"%s\"", this.getValue());
    }

    public static class NonNullTerminated
    extends RPCUnicodeString {
        public static NonNullTerminated of(String value) {
            NonNullTerminated str = new NonNullTerminated();
            str.setValue(value);
            return str;
        }

        @Override
        WChar createWChar() {
            return new WChar.NonNullTerminated();
        }
    }

    public static class NullTerminated
    extends RPCUnicodeString {
        public static NullTerminated of(String value) {
            NullTerminated str = new NullTerminated();
            str.setValue(value);
            return str;
        }

        @Override
        WChar createWChar() {
            return new WChar.NullTerminated();
        }
    }
}

