/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.helper.smbj.io;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2PacketHeader;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.session.Session;
import com.rapid7.helper.smbj.io.SMB2Exception;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.EnumSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SMB2SessionMessage {
    private final SMB2Dialect dialect;
    private final Session session;
    private final long sessionID;
    private final long timeout;

    public SMB2SessionMessage(Session session, SmbConfig config) {
        this.dialect = session.getConnection().getNegotiatedProtocol().getDialect();
        this.session = session;
        this.sessionID = session.getSessionId();
        this.timeout = config.getTransactTimeout();
    }

    public SMB2Dialect getDialect() {
        return this.dialect;
    }

    public Session getSession() {
        return this.session;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public <T extends SMB2Packet> Future<T> send(SMB2Packet packet) throws IOException {
        try {
            return this.getSession().send(packet);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public <T extends SMB2Packet> T read(Future<T> future) throws IOException {
        try {
            return (T)((SMB2Packet)future.get(this.timeout, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException exception) {
            InterruptedIOException innerException = new InterruptedIOException();
            innerException.initCause(exception);
            throw innerException;
        }
        catch (TimeoutException exception) {
            InterruptedByTimeoutException innerException = new InterruptedByTimeoutException();
            innerException.initCause(exception);
            throw innerException;
        }
        catch (ExecutionException exception) {
            throw new IOException(exception);
        }
    }

    public <T extends SMB2Packet> T sendAndRead(SMB2Packet packet) throws IOException {
        Future<T> future = this.send(packet);
        return this.read(future);
    }

    public <T extends SMB2Packet> T sendAndRead(SMB2Packet packet, EnumSet<NtStatus> ok) throws IOException {
        Future<T> future = this.send(packet);
        T responsePacket = this.read(future);
        SMB2PacketHeader responseHeader = (SMB2PacketHeader)responsePacket.getHeader();
        NtStatus responseStatus = NtStatus.valueOf((long)responseHeader.getStatusCode());
        if (!ok.contains(responseStatus)) {
            throw new SMB2Exception(responseHeader, "expected=" + ok);
        }
        return responsePacket;
    }
}

