/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.net;

import com.google.common.base.Strings;
import com.rapid7.net.LogentriesClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;

public class AsyncLogger {
    public static final int LOG_LENGTH_LIMIT = 65536;
    private static final int QUEUE_SIZE = 32768;
    private static final int RECURSION_LIMIT = 32;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int MIN_DELAY = 100;
    private static final int MAX_DELAY = 10000;
    private static final String LE = "LE ";
    private static final String LINE_SEP = System.getProperty("line_separator", "\n");
    private static final String INVALID_TOKEN = "\n\nIt appears your LOGENTRIES_TOKEN parameter in log4j.xml is incorrect!\n\n";
    private static final String INVALID_REGION = "\n\nMissing REGION parameter in logger configuration.\n\n";
    private static final String CONFIG_TOKEN = "LOGENTRIES_TOKEN";
    private static final String QUEUE_OVERFLOW = "\n\nLogentries Buffer Queue Overflow. Message Dropped!\n\n";
    private static final String LIBRARY_ID = "###J01### - Library initialised";
    private static final Pattern HOSTNAME_REGEX = Pattern.compile("[$/\\\"&+,:;=?#|<>_* \\[\\]]");
    String token = "";
    String region;
    String key = "";
    String location = "";
    boolean httpPut = false;
    boolean ssl = false;
    boolean debug = false;
    boolean local = false;
    boolean useDataHub = false;
    String dataHubAddr = null;
    int dataHubPort;
    boolean logHostName = false;
    String hostName = "";
    String logID = "";
    boolean started = false;
    SocketAppender appender;
    ArrayBlockingQueue<String> queue;

    AsyncLogger(boolean local) {
        this.local = local;
        this.queue = new ArrayBlockingQueue(32768);
        this.queue.offer(LIBRARY_ID);
        this.appender = new SocketAppender();
    }

    public AsyncLogger() {
        this(false);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.dbg("Setting token to " + token);
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public boolean getHttpPut() {
        return this.httpPut;
    }

    public void setHttpPut(boolean HttpPut) {
        this.httpPut = HttpPut;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String account_key) {
        this.key = account_key;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String log_location) {
        this.location = log_location;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.dbg("Setting debug to " + debug);
    }

    public boolean getUseDataHub() {
        return this.useDataHub;
    }

    public void setUseDataHub(boolean isUsingDataHub) {
        this.useDataHub = isUsingDataHub;
    }

    public String getDataHubAddr() {
        return this.dataHubAddr;
    }

    public void setDataHubAddr(String dataHubAddr) {
        this.dataHubAddr = dataHubAddr;
    }

    public int getDataHubPort() {
        return this.dataHubPort;
    }

    public void setDataHubPort(int dataHubPort) {
        this.dataHubPort = dataHubPort;
    }

    public boolean getLogHostName() {
        return this.logHostName;
    }

    public void setLogHostName(boolean logHostName) {
        this.logHostName = logHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getLogID() {
        return this.logID;
    }

    public void setLogID(String logID) {
        this.logID = logID;
    }

    boolean checkValidUUID(String uuid) {
        if ("".equals(uuid)) {
            return false;
        }
        try {
            UUID u = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    String getEnvVar(String key) {
        String envVal = System.getenv(key);
        return envVal != null ? envVal : "";
    }

    boolean checkCredentials() {
        if (Strings.isNullOrEmpty((String)this.region)) {
            this.dbg(INVALID_REGION);
            return false;
        }
        if (!this.httpPut) {
            if (this.token.equals(CONFIG_TOKEN) || this.token.equals("")) {
                String envToken = this.getEnvVar(CONFIG_TOKEN);
                if (envToken.equals("")) {
                    this.dbg(INVALID_TOKEN);
                    return false;
                }
                this.setToken(envToken);
            }
            return this.checkValidUUID(this.getToken());
        }
        return this.checkValidUUID(this.getKey()) && !this.getLocation().equals("");
    }

    boolean checkIfHostNameValid(String hostName) {
        return !HOSTNAME_REGEX.matcher(hostName).find();
    }

    public void addLineToQueue(String line) {
        this.addLineToQueue(line, 32);
    }

    private void addLineToQueue(String line, int limit) {
        if (limit == 0) {
            this.dbg("Message longer than 2097152");
            return;
        }
        if (!this.started && (this.useDataHub || this.checkCredentials())) {
            this.dbg("Starting Logentries asynchronous socket appender");
            this.appender.start();
            this.started = true;
        }
        this.dbg("Queueing " + line);
        if (line.length() > 65536) {
            if (!this.queue.offer(line.substring(0, 65536))) {
                this.queue.poll();
                if (!this.queue.offer(line.substring(0, 65536))) {
                    this.dbg(QUEUE_OVERFLOW);
                }
            }
            this.addLineToQueue(line.substring(65536, line.length()), limit - 1);
        } else if (!this.queue.offer(line)) {
            this.queue.poll();
            if (!this.queue.offer(line)) {
                this.dbg(QUEUE_OVERFLOW);
            }
        }
    }

    public void close() {
        this.appender.interrupt();
        this.started = false;
        this.dbg("Closing Logentries asynchronous socket appender");
    }

    void dbg(String msg) {
        if (this.debug) {
            if (!msg.endsWith(LINE_SEP)) {
                System.err.println(LE + msg);
            } else {
                System.err.print(LE + msg);
            }
        }
    }

    static /* synthetic */ String access$100() {
        return LINE_SEP;
    }

    static /* synthetic */ Charset access$200() {
        return UTF8;
    }

    class SocketAppender
    extends Thread {
        final Random random;
        LogentriesClient le_client;

        SocketAppender() {
            super("Logentries Socket appender");
            this.random = new Random();
            this.setDaemon(true);
        }

        void openConnection() throws IOException {
            try {
                if (this.le_client == null) {
                    this.le_client = new LogentriesClient(AsyncLogger.this.httpPut, AsyncLogger.this.ssl, AsyncLogger.this.useDataHub, AsyncLogger.this.dataHubAddr, AsyncLogger.this.dataHubPort, AsyncLogger.this.region);
                }
                this.le_client.connect();
                if (AsyncLogger.this.httpPut) {
                    String f = "PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n";
                    String header = String.format("PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n", AsyncLogger.this.key, AsyncLogger.this.location);
                    byte[] temp = header.getBytes(ASCII);
                    this.le_client.write(temp, 0, temp.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void reopenConnection() throws InterruptedException {
            this.closeConnection();
            int root_delay = 100;
            while (true) {
                try {
                    this.openConnection();
                    return;
                }
                catch (IOException e) {
                    if (AsyncLogger.this.debug) {
                        AsyncLogger.this.dbg("Unable to connect to Logentries");
                        e.printStackTrace();
                    }
                    if ((root_delay *= 2) > 10000) {
                        root_delay = 10000;
                    }
                    int wait_for = root_delay + this.random.nextInt(root_delay);
                    AsyncLogger.this.dbg("Waiting for " + wait_for + "ms");
                    Thread.sleep(wait_for);
                    continue;
                }
                break;
            }
        }

        void closeConnection() {
            if (this.le_client != null) {
                this.le_client.close();
            }
        }

        private void buildPrefixMessage(StringBuilder sb) {
            if (!AsyncLogger.this.logID.isEmpty()) {
                sb.append(AsyncLogger.this.logID).append(" ");
            }
            if (AsyncLogger.this.logHostName) {
                if (AsyncLogger.this.hostName.isEmpty()) {
                    AsyncLogger.this.dbg("Host name is not defined by user - trying to obtain it from the environment.");
                    try {
                        AsyncLogger.this.hostName = InetAddress.getLocalHost().getHostName();
                        sb.append("HostName=").append(AsyncLogger.this.hostName).append(" ");
                    }
                    catch (UnknownHostException e) {
                        AsyncLogger.this.dbg("Failed to get host name automatically; Host name will not be used in prefix.");
                    }
                } else if (!AsyncLogger.this.checkIfHostNameValid(AsyncLogger.this.hostName)) {
                    AsyncLogger.this.dbg("There are some prohibited characters found in the host name defined in the config; Host name will not be used in prefix.");
                } else {
                    sb.append("HostName=").append(AsyncLogger.this.hostName).append(" ");
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                this.reopenConnection();
                logMessagePrefix = "";
                sb = new StringBuilder(logMessagePrefix);
                this.buildPrefixMessage(sb);
                logPrefixEmpty = sb.toString().isEmpty();
                if (!logPrefixEmpty) {
                    logMessagePrefix = sb.toString();
                }
                finalDataBuilder = new StringBuilder("");
                block4: while (true) lbl-1000:
                // 2 sources

                {
                    data = AsyncLogger.this.queue.take();
                    data = data.replace(AsyncLogger.access$100(), "\u2028");
                    finalDataBuilder.setLength(0);
                    if (!AsyncLogger.this.httpPut && !AsyncLogger.this.useDataHub) {
                        finalDataBuilder.append(AsyncLogger.this.token);
                    }
                    if (!logPrefixEmpty) {
                        finalDataBuilder.append(logMessagePrefix);
                    }
                    finalDataBuilder.append(data).append('\n');
                    finalLine = finalDataBuilder.toString().getBytes(AsyncLogger.access$200());
                    while (true) {
                        try {
                            this.le_client.write(finalLine, 0, finalLine.length);
                            continue block4;
                        }
                        catch (IOException e) {
                            this.reopenConnection();
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                AsyncLogger.this.dbg("Asynchronous socket writer interrupted");
                AsyncLogger.this.dbg("Queue had " + AsyncLogger.this.queue.size() + " lines left in it");
                this.closeConnection();
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

