/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class LogentriesClient {
    private static final int LE_PORT = 80;
    private static final int LE_SSL_PORT = 443;
    final SSLSocketFactory ssl_factory;
    private boolean ssl_choice = false;
    private boolean http_choice = false;
    private Socket socket;
    private OutputStream stream;
    private int dataHubPort = 80;
    private boolean useDataHub = false;
    private String dataEndpoint;
    private String httpEndpoint;
    private String dataHubServer = this.dataEndpoint;

    public LogentriesClient(boolean httpPut, boolean ssl, boolean isUsingDataHub, String server, int port, String region) {
        if (isUsingDataHub) {
            this.ssl_factory = null;
            this.ssl_choice = false;
            this.useDataHub = true;
            this.dataHubServer = server;
            this.dataHubPort = port;
        } else {
            this.ssl_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.ssl_choice = ssl;
            this.http_choice = httpPut;
        }
        this.dataEndpoint = String.format("%s.data.logs.insight.rapid7.com", region);
        this.httpEndpoint = String.format("%s.api.logs.insight.rapid7.com", region);
    }

    public int getPort() {
        if (this.useDataHub) {
            return this.dataHubPort;
        }
        if (this.ssl_choice) {
            return 443;
        }
        return 80;
    }

    public String getAddress() {
        if (this.useDataHub) {
            return this.dataHubServer;
        }
        if (this.http_choice) {
            return this.httpEndpoint;
        }
        return this.dataEndpoint;
    }

    public void connect() throws IOException {
        if (this.ssl_choice) {
            if (this.http_choice) {
                SSLSocket s = (SSLSocket)this.ssl_factory.createSocket(this.getAddress(), this.getPort());
                s.setTcpNoDelay(true);
                s.startHandshake();
                this.socket = s;
            } else {
                this.socket = SSLSocketFactory.getDefault().createSocket(this.getAddress(), this.getPort());
            }
        } else {
            this.socket = new Socket(this.getAddress(), this.getPort());
        }
        this.stream = this.socket.getOutputStream();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.stream == null) {
            throw new IOException();
        }
        this.stream.write(buffer, offset, length);
        this.stream.flush();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

