/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.net;

public class LoggerConfiguration {
    private String token;
    private String region;
    private String key;
    private String location;
    private boolean httpPut;
    private boolean ssl;
    private boolean debug;
    private boolean useDataHub;
    private String dataHubAddr;
    private int dataHubPort;
    private boolean logHostName;
    private String hostName;
    private String logID;

    private LoggerConfiguration() {
    }

    public String getToken() {
        return this.token;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isHttpPut() {
        return this.httpPut;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isUseDataHub() {
        return this.useDataHub;
    }

    public String getDataHubAddr() {
        return this.dataHubAddr;
    }

    public int getDataHubPort() {
        return this.dataHubPort;
    }

    public boolean isLogHostName() {
        return this.logHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getLogID() {
        return this.logID;
    }

    public String getRegion() {
        return this.region;
    }

    public static class Builder {
        private String token;
        private String region;
        private String key;
        private String location = "";
        private boolean httpPut;
        private boolean ssl = true;
        private boolean debug;
        private boolean useDataHub;
        private String dataHubAddr;
        private int dataHubPort;
        private boolean logHostName;
        private String hostName;
        private String logID;

        public Builder useToken(String token) {
            this.token = token;
            return this;
        }

        public Builder inRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder useAccountKey(String key) {
            this.key = key;
            return this;
        }

        public Builder useHttpPut(boolean httpPut) {
            this.httpPut = httpPut;
            return this;
        }

        public Builder httpPutLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder runInDebugMode(boolean debugMode) {
            this.debug = debugMode;
            return this;
        }

        public Builder useSSL(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder useDataHub(boolean useDataHub) {
            this.useDataHub = useDataHub;
            return this;
        }

        public Builder toServerAddress(String address) {
            this.dataHubAddr = address;
            return this;
        }

        public Builder toServerPort(int port) {
            this.dataHubPort = port;
            return this;
        }

        public Builder logHostNameAsPrefix(boolean logHostName) {
            this.logHostName = logHostName;
            return this;
        }

        public Builder useAsHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setLogIdPrefix(String logID) {
            this.logID = logID;
            return this;
        }

        public LoggerConfiguration build() {
            LoggerConfiguration configuration = new LoggerConfiguration();
            configuration.token = this.token;
            configuration.region = this.region;
            configuration.key = this.key;
            configuration.location = this.location;
            configuration.httpPut = this.httpPut;
            configuration.ssl = this.ssl;
            configuration.debug = this.debug;
            configuration.useDataHub = this.useDataHub;
            configuration.dataHubAddr = this.dataHubAddr;
            configuration.dataHubPort = this.dataHubPort;
            configuration.logHostName = this.logHostName;
            configuration.hostName = this.hostName;
            configuration.logID = this.logID;
            return configuration;
        }
    }
}

