/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.logback;

import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.rapid7.net.AsyncLogger;
import com.rapid7.net.LoggerConfiguration;
import java.nio.charset.StandardCharsets;

public abstract class LogentriesAppenderBase<E extends DeferredProcessingAware, C extends PatternLayoutBase>
extends AppenderBase<E> {
    public AsyncLogger iopsAsync;
    private final LoggerConfiguration.Builder configurationBuilder = new LoggerConfiguration.Builder();
    private Layout<E> layout;
    private Encoder<E> encoder;
    private String facilityStr;
    private String suffixPattern;

    public void setToken(String token) {
        this.configurationBuilder.useToken(token);
    }

    public void setRegion(String region) {
        this.configurationBuilder.inRegion(region);
    }

    public void setHttpPut(boolean httpPut) {
        this.configurationBuilder.useHttpPut(httpPut);
    }

    public void setKey(String accountKey) {
        this.configurationBuilder.useAccountKey(accountKey);
    }

    public void setLocation(String logLocation) {
        this.configurationBuilder.httpPutLocation(logLocation);
    }

    public void setSsl(boolean ssl) {
        this.configurationBuilder.useSSL(ssl);
    }

    public void setDebug(boolean debug) {
        this.configurationBuilder.runInDebugMode(debug);
    }

    public void setIsUsingDataHub(boolean useDataHub) {
        this.configurationBuilder.useDataHub(useDataHub);
    }

    public void setDataHubAddr(String dataHubAddr) {
        this.configurationBuilder.toServerAddress(dataHubAddr);
    }

    public void setDataHubPort(int dataHubPort) {
        this.configurationBuilder.toServerPort(dataHubPort);
    }

    public void setLogHostName(boolean logHostName) {
        this.configurationBuilder.logHostNameAsPrefix(logHostName);
    }

    public void setHostName(String hostName) {
        this.configurationBuilder.useAsHostName(hostName);
    }

    public void setLogID(String logID) {
        this.configurationBuilder.setLogIdPrefix(logID);
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public void start() {
        if (this.encoder == null) {
            this.layout = this.layout == null ? this.buildLayout() : this.layout;
            LayoutWrappingEncoder lwe = new LayoutWrappingEncoder();
            lwe.setLayout(this.layout);
            lwe.setContext(this.getContext());
            this.encoder = lwe;
        }
        this.iopsAsync = new AsyncLogger(this.configurationBuilder.build());
        super.start();
    }

    String getPrefixPattern() {
        return "%syslogStart{" + this.getFacility() + "}%nopex";
    }

    public String getFacility() {
        return this.facilityStr;
    }

    public void setFacility(String facilityStr) {
        if (facilityStr != null) {
            facilityStr = facilityStr.trim();
        }
        this.facilityStr = facilityStr;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public void append(E event) {
        byte[] encodedEvent = this.encoder.encode(event);
        String formattedEvent = new String(encodedEvent, StandardCharsets.UTF_8);
        this.iopsAsync.addLineToQueue(formattedEvent);
    }

    public void stop() {
        super.stop();
        this.iopsAsync.close();
    }

    public Layout<E> buildLayout() {
        C l = this.getPatternLayout();
        l.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = this.getDefaultSuffixPattern();
        }
        l.setPattern(this.getPrefixPattern() + this.suffixPattern);
        l.setContext(this.getContext());
        l.start();
        return l;
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    public void setSuffixPattern(String suffixPattern) {
        this.suffixPattern = suffixPattern;
    }

    public abstract C getPatternLayout();

    public abstract String getDefaultSuffixPattern();
}

