/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.net;

import com.rapid7.net.InsightOpsClient;
import com.rapid7.net.LoggerConfiguration;
import com.rapid7.net.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.IllegalFormatException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;

public final class AsyncLogger {
    public static final int LOG_LENGTH_LIMIT = 65536;
    private static final int QUEUE_SIZE = 32768;
    private static final int RECURSION_LIMIT = 32;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Charset ASCII = StandardCharsets.US_ASCII;
    private static final int MIN_DELAY = 100;
    private static final int MAX_DELAY = 10000;
    private static final String IOPS = "IOPS ";
    private static final String LINE_SEP = System.getProperty("line_separator", "\n");
    private static final String INVALID_TOKEN = "\n\nIt appears your LOGENTRIES_TOKEN parameter in log4j.xml is incorrect!\n\n";
    private static final String INVALID_REGION = "\n\nMissing REGION parameter in logger configuration.\n\n";
    private static final String CONFIG_TOKEN = "LOGENTRIES_TOKEN";
    private static final String QUEUE_OVERFLOW = "\n\nInsightOps Buffer Queue Overflow. Message Dropped!\n\n";
    private static final String LIBRARY_ID = "###J01### - Library initialised";
    private static final Pattern HOSTNAME_REGEX = Pattern.compile("[$/\\\"&+,:;=?#|<>_* \\[\\]]");
    private final String token;
    private final String region;
    private final String key;
    private final String location;
    private final boolean httpPut;
    private final boolean ssl;
    private final boolean debug;
    private final boolean useDataHub;
    private final String dataHubAddr;
    private final int dataHubPort;
    private final boolean logHostName;
    private final String hostName;
    private final String logID;
    private boolean started = false;
    private final SocketAppender appender;
    private final ArrayBlockingQueue<String> queue = new ArrayBlockingQueue(32768);
    private final String logMessagePrefix;

    public AsyncLogger(LoggerConfiguration configuration) {
        this.queue.offer(LIBRARY_ID);
        this.region = configuration.getRegion();
        this.token = this.calculateToken(configuration);
        this.key = configuration.getKey();
        this.location = configuration.getLocation();
        this.httpPut = configuration.isHttpPut();
        this.ssl = configuration.isSsl();
        this.debug = configuration.isDebug();
        this.useDataHub = configuration.isUseDataHub();
        this.dataHubAddr = configuration.getDataHubAddr();
        this.dataHubPort = configuration.getDataHubPort();
        this.logHostName = configuration.isLogHostName();
        this.hostName = this.calculateHostName(configuration);
        this.logID = configuration.getLogID();
        this.logMessagePrefix = this.buildPrefixMessage();
        this.appender = new SocketAppender();
    }

    private String calculateToken(LoggerConfiguration configuration) {
        if (!configuration.isHttpPut() && (Utils.isNullOrEmpty(configuration.getToken()) || configuration.getToken().equals(CONFIG_TOKEN))) {
            String envToken = this.getEnvVar(CONFIG_TOKEN);
            if (envToken.equals("")) {
                this.dbg(INVALID_TOKEN, new Object[0]);
            }
            return envToken;
        }
        return configuration.getToken();
    }

    private String calculateHostName(LoggerConfiguration configuration) {
        if (configuration.isLogHostName()) {
            if (Utils.isNullOrEmpty(configuration.getHostName())) {
                this.dbg("Host name is not defined by user - trying to obtain it from the environment.", new Object[0]);
                try {
                    return InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.dbg("Failed to get host name automatically; Host name will not be used in prefix.", new Object[0]);
                }
            } else if (!this.checkIfHostNameValid(configuration.getHostName())) {
                this.dbg("There are some prohibited characters found in the host name defined in the config; Host name will not be used in prefix.", new Object[0]);
                return null;
            }
        }
        return configuration.getHostName();
    }

    public String getToken() {
        return this.token;
    }

    String getLogMessagePrefix() {
        return this.logMessagePrefix;
    }

    public String getRegion() {
        return this.region;
    }

    public boolean getHttpPut() {
        return this.httpPut;
    }

    public String getKey() {
        return this.key;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getUseDataHub() {
        return this.useDataHub;
    }

    public String getDataHubAddr() {
        return this.dataHubAddr;
    }

    public int getDataHubPort() {
        return this.dataHubPort;
    }

    public boolean getLogHostName() {
        return this.logHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getLogID() {
        return this.logID;
    }

    boolean checkValidUUID(String uuid) {
        if ("".equals(uuid)) {
            return false;
        }
        try {
            UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    SocketAppender getAppender() {
        return this.appender;
    }

    private String getEnvVar(String key) {
        String envVal = System.getenv(key);
        return envVal != null ? envVal : "";
    }

    boolean checkCredentials() {
        if (Utils.isNullOrEmpty(this.region)) {
            this.dbg(INVALID_REGION, new Object[0]);
            return false;
        }
        if (!this.httpPut) {
            return this.checkValidUUID(this.getToken());
        }
        return this.checkValidUUID(this.getKey()) && !Utils.isNullOrEmpty(this.location);
    }

    private String buildPrefixMessage() {
        StringBuilder sb = new StringBuilder();
        if (!Utils.isNullOrEmpty(this.logID)) {
            sb.append(this.logID).append(" ");
        }
        if (this.logHostName && !Utils.isNullOrEmpty(this.hostName)) {
            sb.append("HostName=").append(this.hostName).append(" ");
        }
        return sb.toString();
    }

    boolean checkIfHostNameValid(String hostName) {
        return !HOSTNAME_REGEX.matcher(hostName).find();
    }

    public void addLineToQueue(String line) {
        this.addLineToQueue(line, 32);
    }

    private void addLineToQueue(String line, int limit) {
        if (limit == 0) {
            this.dbg("Message longer than 2097152", new Object[0]);
            return;
        }
        if (!this.started && (this.useDataHub || this.checkCredentials())) {
            this.dbg("Starting InsightOps asynchronous socket appender", new Object[0]);
            this.appender.start();
            this.started = true;
        }
        this.dbg("Queueing %s", line);
        if (line.length() > 65536) {
            if (!this.queue.offer(line.substring(0, 65536))) {
                this.queue.poll();
                if (!this.queue.offer(line.substring(0, 65536))) {
                    this.dbg(QUEUE_OVERFLOW, new Object[0]);
                }
            }
            this.addLineToQueue(line.substring(65536), limit - 1);
        } else if (!this.queue.offer(line)) {
            this.queue.poll();
            if (!this.queue.offer(line)) {
                this.dbg(QUEUE_OVERFLOW, new Object[0]);
            }
        }
    }

    public void close() {
        this.appender.interrupt();
        this.started = false;
        this.dbg("Closing InsightOps asynchronous socket appender", new Object[0]);
    }

    void dbg(String msg, Object ... argv) {
        if (this.debug) {
            if (!msg.endsWith(LINE_SEP)) {
                System.err.println(IOPS + String.format(msg, argv));
            } else {
                System.err.print(IOPS + String.format(msg, argv));
            }
        }
    }

    void warn(String msg, Object ... argv) {
        try {
            System.err.print(IOPS);
            System.err.printf(msg, argv);
            System.err.println();
        }
        catch (IllegalFormatException e) {
            System.err.println(msg);
            System.err.println("IOPS  suppressed IllegalFormatException");
        }
    }

    void warn(Throwable t) {
        if (t != null) {
            System.err.print(IOPS);
            t.printStackTrace(System.err);
        }
    }

    static /* synthetic */ ArrayBlockingQueue access$900(AsyncLogger x0) {
        return x0.queue;
    }

    static /* synthetic */ String access$1000() {
        return LINE_SEP;
    }

    static /* synthetic */ String access$1100(AsyncLogger x0) {
        return x0.token;
    }

    static /* synthetic */ String access$1200(AsyncLogger x0) {
        return x0.logMessagePrefix;
    }

    static /* synthetic */ Charset access$1300() {
        return UTF8;
    }

    class SocketAppender
    extends Thread {
        final Random random;
        InsightOpsClient iopsClient;

        SocketAppender() {
            super("InsightOps Socket appender");
            this.random = new Random();
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((t, e) -> {
                AsyncLogger.this.warn("uncaught exception from %s : %s", t.getName(), e.getMessage());
                AsyncLogger.this.warn(e);
            });
        }

        void openConnection() throws IOException {
            if (this.iopsClient == null) {
                this.iopsClient = new InsightOpsClient(AsyncLogger.this.httpPut, AsyncLogger.this.ssl, AsyncLogger.this.useDataHub, AsyncLogger.this.dataHubAddr, AsyncLogger.this.dataHubPort, AsyncLogger.this.region);
            }
            this.iopsClient.connect();
            if (AsyncLogger.this.httpPut) {
                String f = "PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n";
                String header = String.format("PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n", AsyncLogger.this.key, AsyncLogger.this.location);
                byte[] temp = header.getBytes(ASCII);
                this.iopsClient.write(temp, 0, temp.length);
            }
        }

        void reopenConnection() throws InterruptedException {
            AsyncLogger.this.dbg("reopenConnection entered", new Object[0]);
            this.closeConnection();
            int rootDelay = 100;
            while (true) {
                try {
                    this.openConnection();
                    return;
                }
                catch (IOException e) {
                    AsyncLogger.this.warn("Unable to connect to InsightOps", new Object[0]);
                    AsyncLogger.this.warn(e);
                    if ((rootDelay *= 2) > 10000) {
                        rootDelay = 10000;
                    }
                    int waitFor = rootDelay + this.random.nextInt(rootDelay);
                    AsyncLogger.this.warn("Waiting for %d ms", waitFor);
                    Thread.sleep(waitFor);
                    continue;
                }
                break;
            }
        }

        void closeConnection() {
            if (this.iopsClient != null) {
                this.iopsClient.close();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                this.reopenConnection();
                finalDataBuilder = new StringBuilder();
                block4: while (true) lbl-1000:
                // 2 sources

                {
                    data = (String)AsyncLogger.access$900(AsyncLogger.this).take();
                    data = data.replace(AsyncLogger.access$1000(), "\u2028");
                    finalDataBuilder.setLength(0);
                    if (!AsyncLogger.access$000(AsyncLogger.this) && !AsyncLogger.access$200(AsyncLogger.this)) {
                        finalDataBuilder.append(AsyncLogger.access$1100(AsyncLogger.this));
                    }
                    if (!Utils.isNullOrEmpty(AsyncLogger.access$1200(AsyncLogger.this))) {
                        finalDataBuilder.append(AsyncLogger.access$1200(AsyncLogger.this));
                    }
                    finalDataBuilder.append(data).append('\n');
                    finalLine = finalDataBuilder.toString().getBytes(AsyncLogger.access$1300());
                    while (true) {
                        try {
                            this.iopsClient.write(finalLine, 0, finalLine.length);
                            continue block4;
                        }
                        catch (IOException e) {
                            this.reopenConnection();
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                AsyncLogger.this.dbg("Asynchronous socket writer interrupted", new Object[0]);
                if (AsyncLogger.access$900(AsyncLogger.this).isEmpty()) {
                    AsyncLogger.this.dbg("interrupted; queue is empty", new Object[0]);
                } else {
                    AsyncLogger.this.warn("interrupted; queue had %d lines left in it", new Object[]{AsyncLogger.access$900(AsyncLogger.this).size()});
                }
                Thread.currentThread().interrupt();
                this.closeConnection();
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

