/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.ownership;

import com.raquo.airstream.core.Transaction$onStart$;
import com.raquo.airstream.ownership.DynamicSubscription;
import com.raquo.airstream.ownership.OneTimeOwner;
import com.raquo.airstream.ownership.Owner;
import com.raquo.ew.JsArray;
import com.raquo.ew.JsArray$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class DynamicOwner {
    private final Function0<BoxedUnit> onAccessAfterKilled;
    private final JsArray<DynamicSubscription> subscriptions;
    private boolean isSafeToRemoveSubscription;
    private final JsArray<DynamicSubscription> pendingSubscriptionRemovals;
    private Option<Owner> _maybeCurrentOwner;
    private int numPrependedSubs;

    public DynamicOwner(Function0<BoxedUnit> onAccessAfterKilled) {
        this.onAccessAfterKilled = onAccessAfterKilled;
        this.subscriptions = JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
        this.isSafeToRemoveSubscription = true;
        this.pendingSubscriptionRemovals = JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
        this._maybeCurrentOwner = None$.MODULE$;
        this.numPrependedSubs = 0;
    }

    public Option<Owner> maybeCurrentOwner() {
        return this._maybeCurrentOwner;
    }

    public boolean isActive() {
        return this._maybeCurrentOwner.isDefined();
    }

    public boolean hasSubscriptions() {
        return this.numSubscriptions() != 0;
    }

    public int numSubscriptions() {
        return this.subscriptions.length();
    }

    public void activate() {
        if (!this.isActive()) {
            Transaction$onStart$.MODULE$.shared((Function0 & Serializable)() -> {
                this.activate$$anonfun$1();
                return BoxedUnit.UNIT;
            }, Transaction$onStart$.MODULE$.shared$default$2());
            return;
        }
        throw new Exception(new StringBuilder(39).append("Can not activate ").append(this).append(": it is already active").toString());
    }

    public void deactivate() {
        if (this.isActive()) {
            this.isSafeToRemoveSubscription = false;
            JsArray jsArray = JsArray$.MODULE$.RichJsArray(this.subscriptions);
            JsArray.RichJsArray$.MODULE$.forEach$extension(jsArray, _$1 -> {
                _$1.onDeactivate();
                return BoxedUnit.UNIT;
            });
            this.removePendingSubscriptionsNow();
            this._maybeCurrentOwner.foreach((Function1 & Serializable)_$2 -> {
                _$2._killSubscriptions();
                return BoxedUnit.UNIT;
            });
            this.removePendingSubscriptionsNow();
            this.isSafeToRemoveSubscription = true;
            this._maybeCurrentOwner = None$.MODULE$;
            return;
        }
        throw new Exception("Can not deactivate DynamicOwner: it is not active");
    }

    public void addSubscription(DynamicSubscription subscription, boolean prepend) {
        int n;
        if (prepend) {
            ++this.numPrependedSubs;
            n = this.subscriptions.unshift((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
        } else {
            n = this.subscriptions.push((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
        }
        this._maybeCurrentOwner.foreach((Function1 & Serializable)o -> {
            subscription.onActivate(o);
            return BoxedUnit.UNIT;
        });
    }

    public void removeSubscription(DynamicSubscription subscription) {
        if (this.isSafeToRemoveSubscription) {
            this.removeSubscriptionNow(subscription);
            return;
        }
        this.pendingSubscriptionRemovals.push((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[]{subscription}));
    }

    private void removeSubscriptionNow(DynamicSubscription subscription) {
        int index = this.subscriptions.indexOf((Object)subscription, this.subscriptions.indexOf$default$2());
        if (index != -1) {
            this.subscriptions.splice(index, 1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DynamicSubscription[0]));
            if (this.isActive()) {
                subscription.onDeactivate();
                return;
            }
            return;
        }
        throw new Exception("Can not remove DynamicSubscription from DynamicOwner: subscription not found. Did you already kill it?");
    }

    private void removePendingSubscriptionsNow() {
        while (this.pendingSubscriptionRemovals.length() > 0) {
            DynamicSubscription subscriptionToRemove = (DynamicSubscription)this.pendingSubscriptionRemovals.shift();
            this.removeSubscriptionNow(subscriptionToRemove);
        }
    }

    private final void activate$$anonfun$1() {
        OneTimeOwner newOwner = new OneTimeOwner(this.onAccessAfterKilled);
        this._maybeCurrentOwner = Some$.MODULE$.apply((Object)newOwner);
        this.isSafeToRemoveSubscription = false;
        this.numPrependedSubs = 0;
        int originalNumSubs = this.subscriptions.length();
        for (int i = 0; i < originalNumSubs; ++i) {
            int ix = i + this.numPrependedSubs;
            DynamicSubscription sub = (DynamicSubscription)this.subscriptions.apply(ix);
            sub.onActivate(newOwner);
        }
        this.removePendingSubscriptionsNow();
        this.isSafeToRemoveSubscription = true;
        this.numPrependedSubs = 0;
    }
}

