/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.ownership;

import com.raquo.airstream.ownership.Owner;
import scala.Function0;
import scala.runtime.BoxedUnit;

public class Subscription {
    private final Owner owner;
    private final Function0<BoxedUnit> cleanup;
    private boolean _isKilled;

    public Subscription(Owner owner, Function0<BoxedUnit> cleanup) {
        this.owner = owner;
        this.cleanup = cleanup;
        this._isKilled = false;
        owner.own(this);
    }

    public Owner owner() {
        return this.owner;
    }

    public boolean isKilled() {
        return this._isKilled;
    }

    public void kill() {
        this.safeCleanup();
        this.owner().onKilledExternally(this);
    }

    public void onKilledByOwner() {
        this.safeCleanup();
    }

    private void safeCleanup() {
        if (!this._isKilled) {
            this.cleanup.apply();
            this._isKilled = true;
            return;
        }
        throw new Exception("Can not kill Subscription: it was already killed.");
    }
}

