/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.airstream.ownership;

import com.raquo.airstream.ownership.DynamicOwner;
import com.raquo.airstream.ownership.DynamicSubscription;
import com.raquo.airstream.ownership.DynamicSubscription$;
import com.raquo.airstream.ownership.Owner;
import com.raquo.airstream.ownership.Subscription;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;

public class TransferableSubscription {
    private final Function0<BoxedUnit> activate;
    private final Function0<BoxedUnit> deactivate;
    private Option<DynamicSubscription> maybeSubscription;
    private boolean isLiveTransferInProgress;

    public TransferableSubscription(Function0<BoxedUnit> activate, Function0<BoxedUnit> deactivate) {
        this.activate = activate;
        this.deactivate = deactivate;
        this.maybeSubscription = None$.MODULE$;
        this.isLiveTransferInProgress = false;
    }

    public boolean hasOwner() {
        return this.maybeSubscription.nonEmpty();
    }

    public boolean isCurrentOwnerActive() {
        return this.maybeSubscription.exists((Function1 & Serializable)_$1 -> _$1.isOwnerActive());
    }

    public void setOwner(DynamicOwner nextOwner) {
        if (this.isLiveTransferInProgress) {
            throw new Exception("Unable to set owner on DynamicTransferableSubscription while a transfer on this subscription is already in progress.");
        }
        if (this.maybeSubscription.exists((Function1 & Serializable)_$2 -> _$2.isOwnedBy(nextOwner))) {
            return;
        }
        if (this.isCurrentOwnerActive() && nextOwner.isActive()) {
            this.isLiveTransferInProgress = true;
        }
        this.maybeSubscription.foreach((Function1 & Serializable)subscription -> {
            this.setOwner$$anonfun$2((DynamicSubscription)subscription);
            return BoxedUnit.UNIT;
        });
        DynamicSubscription newPilotSubscription = DynamicSubscription$.MODULE$.unsafe(nextOwner, (Function1<Owner, Subscription>)(Function1 & Serializable)parentOwner -> {
            if (!this.isLiveTransferInProgress) {
                this.activate.apply();
            }
            return new Subscription((Owner)parentOwner, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.$anonfun$1$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }, DynamicSubscription$.MODULE$.unsafe$default$3());
        this.maybeSubscription = Some$.MODULE$.apply((Object)newPilotSubscription);
        this.isLiveTransferInProgress = false;
    }

    public void clearOwner() {
        if (this.isLiveTransferInProgress) {
            throw new Exception("Unable to clear owner on DynamicTransferableSubscription while a transfer on this subscription is already in progress.");
        }
        this.maybeSubscription.foreach((Function1 & Serializable)subscription -> {
            subscription.kill();
            return BoxedUnit.UNIT;
        });
        this.maybeSubscription = None$.MODULE$;
    }

    private final /* synthetic */ void setOwner$$anonfun$2(DynamicSubscription subscription) {
        subscription.kill();
        this.maybeSubscription = None$.MODULE$;
    }

    private final /* synthetic */ void $anonfun$1$$anonfun$1() {
        if (!this.isLiveTransferInProgress) {
            this.deactivate.apply();
            return;
        }
    }
}

