/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.laminar.inputs;

import com.raquo.airstream.ownership.DynamicSubscription;
import com.raquo.ew.JsArray;
import com.raquo.ew.JsArray$;
import com.raquo.laminar.DomApi$;
import com.raquo.laminar.inputs.InputController;
import com.raquo.laminar.keys.EventProcessor$;
import com.raquo.laminar.keys.EventProp;
import com.raquo.laminar.keys.HtmlProp;
import com.raquo.laminar.modifiers.Binder;
import com.raquo.laminar.modifiers.Binder$;
import com.raquo.laminar.modifiers.EventListener;
import com.raquo.laminar.modifiers.KeyUpdater;
import com.raquo.laminar.nodes.ReactiveHtmlElement;
import com.raquo.laminar.tags.CustomHtmlTag;
import com.raquo.laminar.tags.Tag;
import java.io.Serializable;
import org.scalajs.dom.Element;
import org.scalajs.dom.Event;
import org.scalajs.dom.HTMLElement;
import org.scalajs.dom.HTMLInputElement;
import org.scalajs.dom.HTMLSelectElement;
import org.scalajs.dom.HTMLTextAreaElement;
import org.scalajs.dom.Node;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.;
import scala.scalajs.js.UndefOrOps$;
import scala.scalajs.js.internal.UnitOps$;
import scala.scalajs.js.package$;

public final class InputController$
implements Serializable {
    private static final InputController.InputControllerConfig<HTMLElement, String> textValueConfig;
    private static final InputController.InputControllerConfig<HTMLElement, String> selectValueConfig;
    private static final InputController.InputControllerConfig<HTMLElement, Object> checkedConfig;
    private static final JsArray htmlControllableProps;
    public static final InputController$ MODULE$;

    private InputController$() {
    }

    static {
        MODULE$ = new InputController$();
        textValueConfig = new InputController.InputControllerConfig("", com.raquo.laminar.api.package$.MODULE$.L().value(), JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventProp[]{com.raquo.laminar.api.package$.MODULE$.L().onInput()})), (Function1 & Serializable)el -> {
            Object object = UnitOps$.MODULE$.unitOrOps(DomApi$.MODULE$.getValue((Element)el.ref()));
            return (String)UndefOrOps$.MODULE$.getOrElse$extension((.bar)object, this::$init$$$anonfun$2$$anonfun$1);
        }, (Function2 & Serializable)(el, v) -> {
            this.$init$$$anonfun$3((ReactiveHtmlElement)el, (String)v);
            return BoxedUnit.UNIT;
        });
        selectValueConfig = new InputController.InputControllerConfig("", com.raquo.laminar.api.package$.MODULE$.L().value(), JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventProp[]{com.raquo.laminar.api.package$.MODULE$.L().onInput(), com.raquo.laminar.api.package$.MODULE$.L().onChange()})), (Function1 & Serializable)el -> {
            Object object = UnitOps$.MODULE$.unitOrOps(DomApi$.MODULE$.getValue((Element)el.ref()));
            return (String)UndefOrOps$.MODULE$.getOrElse$extension((.bar)object, this::$init$$$anonfun$4$$anonfun$1);
        }, (Function2 & Serializable)(el, v) -> {
            this.$init$$$anonfun$5((ReactiveHtmlElement)el, (String)v);
            return BoxedUnit.UNIT;
        });
        checkedConfig = new InputController.InputControllerConfig(BoxesRunTime.boxToBoolean((boolean)false), com.raquo.laminar.api.package$.MODULE$.L().checked(), JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EventProp[]{com.raquo.laminar.api.package$.MODULE$.L().onInput(), com.raquo.laminar.api.package$.MODULE$.L().onClick()})), (Function1 & Serializable)el -> {
            Object object = UnitOps$.MODULE$.unitOrOps(DomApi$.MODULE$.getChecked((Element)el.ref()));
            return BoxesRunTime.unboxToBoolean((Object)UndefOrOps$.MODULE$.getOrElse$extension((.bar)object, this::$init$$$anonfun$6$$anonfun$1));
        }, (Function2 & Serializable)(v1, v2) -> {
            this.$init$$$anonfun$7((ReactiveHtmlElement)v1, BoxesRunTime.unboxToBoolean((Object)v2));
            return BoxedUnit.UNIT;
        });
        htmlControllableProps = JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"value", "checked"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InputController$.class);
    }

    public <A> InputController.InputControllerConfig<HTMLElement, A> customConfig(HtmlProp<A, ?> prop, JsArray<EventProp<?>> eventProps, A initial) {
        return new InputController.InputControllerConfig(initial, prop, eventProps, (Function1 & Serializable)el -> {
            Object object = UnitOps$.MODULE$.unitOrOps(DomApi$.MODULE$.getHtmlProperty((ReactiveHtmlElement<HTMLElement>)el, prop));
            return UndefOrOps$.MODULE$.get$extension((.bar)object);
        }, (Function2 & Serializable)(el, v) -> {
            this.customConfig$$anonfun$2(prop, (ReactiveHtmlElement)el, v);
            return BoxedUnit.UNIT;
        });
    }

    public <Ref extends HTMLElement, Ev extends Event, A, B> Binder<ReactiveHtmlElement<Ref>> controlled(EventListener<Ev, B> listener, KeyUpdater<ReactiveHtmlElement<Ref>, HtmlProp<A, ?>, A> updater) {
        return Binder$.MODULE$.apply((Function1 & Serializable)element -> {
            String propDomName = ((HtmlProp)updater.key()).name();
            Object maybeControllableProps = element.controllableProps();
            Object object = UnitOps$.MODULE$.unitOrOps(maybeControllableProps);
            boolean isControllableProp = UndefOrOps$.MODULE$.exists$extension((.bar)object, (Function1 & Serializable)_$8 -> {
                JsArray jsArray = JsArray$.MODULE$.RichJsArray(_$8);
                return JsArray.RichJsArray$.MODULE$.includes$extension(jsArray, (Object)propDomName, JsArray.RichJsArray$.MODULE$.includes$default$2$extension(jsArray));
            });
            if (isControllableProp) {
                InputController inputController;
                if (DomApi$.MODULE$.isCustomElement((Element)element.ref())) {
                    Tag tag = element.tag();
                    if (!(tag instanceof CustomHtmlTag)) throw new Exception(new StringBuilder(81).append("Custom element `").append(this.nodeDescription((ReactiveHtmlElement<HTMLElement>)element)).append("` must use CustomHtmlTag in order to support `controlled` inputs.").toString());
                    CustomHtmlTag tag2 = (CustomHtmlTag)tag;
                    Object object2 = UnitOps$.MODULE$.unitOrOps(tag2.allowableControllerConfigForProp((HtmlProp)updater.key()));
                    inputController = (InputController)UndefOrOps$.MODULE$.fold$extension((.bar)object2, () -> this.$anonfun$6(listener, updater, element, propDomName), (Function1 & Serializable)config -> new InputController(config, element, updater, listener));
                } else {
                    Object object3 = UnitOps$.MODULE$.unitOrOps(this.allowedHtmlControllerConfig(element.ref()));
                    inputController = (InputController)UndefOrOps$.MODULE$.fold$extension((.bar)object3, () -> this.$anonfun$8(listener, element, propDomName), (Function1 & Serializable)config -> {
                        InputController.InputControllerConfig assumedConfig = config;
                        return new InputController(assumedConfig, element, updater, listener);
                    });
                }
                InputController controller = inputController;
                return element.bindController(controller);
            }
            String eventPropName = EventProcessor$.MODULE$.eventProp(listener.eventProcessor()).name();
            Object object4 = UnitOps$.MODULE$.unitOrOps(maybeControllableProps);
            return (DynamicSubscription)UndefOrOps$.MODULE$.fold$extension((.bar)object4, () -> this.controlled$$anonfun$1$$anonfun$1(element, propDomName, eventPropName), (Function1 & Serializable)controllableProps -> {
                throw new Exception(this.com$raquo$laminar$inputs$InputController$$$errorMessage(propDomName, eventPropName, (ReactiveHtmlElement<HTMLElement>)element, new StringBuilder(52).append("This element does not support `").append(propDomName).append("` controlled property").toString(), new StringBuilder(34).append("Use `").append(controllableProps.join("` or `")).append("` controlled property instead").toString()));
            });
        });
    }

    public JsArray<String> htmlControllableProps() {
        return htmlControllableProps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <Ref extends HTMLElement> Object allowedHtmlControllerConfig(Ref element) {
        Ref Ref = element;
        if (Ref instanceof HTMLInputElement) {
            HTMLInputElement input = (HTMLInputElement)Ref;
            String string = input.type();
            switch (string == null ? 0 : string.hashCode()) {
                case 3143036: {
                    if (!"file".equals(string)) return textValueConfig;
                    return package$.MODULE$.undefined();
                }
                case 3556653: {
                    if (!"text".equals(string)) return textValueConfig;
                    return textValueConfig;
                }
                case 108270587: {
                    if ("radio".equals(string)) return checkedConfig;
                    return textValueConfig;
                }
                case 1536891843: {
                    if (!"checkbox".equals(string)) return textValueConfig;
                    return checkedConfig;
                }
            }
            return textValueConfig;
        }
        if (Ref instanceof HTMLTextAreaElement) {
            return textValueConfig;
        }
        if (!(Ref instanceof HTMLSelectElement)) return package$.MODULE$.undefined();
        return selectValueConfig;
    }

    private String nodeDescription(ReactiveHtmlElement<HTMLElement> element) {
        Object maybeTyp = DomApi$.MODULE$.getHtmlAttributeRaw(element, com.raquo.laminar.api.package$.MODULE$.L().typ());
        Object object = UnitOps$.MODULE$.unitOrOps(maybeTyp);
        Object object2 = UnitOps$.MODULE$.unitOrOps((Object)UndefOrOps$.MODULE$.map$extension((.bar)object, (Function1 & Serializable)t -> new StringBuilder(8).append(" [type=").append((String)t).append("]").toString()));
        String typSuffix = (String)UndefOrOps$.MODULE$.getOrElse$extension((.bar)object2, this::$anonfun$11);
        return new StringBuilder(0).append(DomApi$.MODULE$.debugNodeDescription((Node)element.ref())).append(typSuffix).toString();
    }

    public String com$raquo$laminar$inputs$InputController$$$errorMessage(String propDomName, String eventPropName, ReactiveHtmlElement<HTMLElement> element, String reason, String suggestion) {
        return JsArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(65).append("Can not add input controller (prop: `").append(propDomName).append("` + event: `").append(eventPropName).append("`) to element `").append(this.nodeDescription(element)).append("`").toString(), StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(reason)) ? new StringBuilder(9).append("- Cause: ").append(reason).toString() : "", StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(suggestion)) ? new StringBuilder(14).append("- Suggestion: ").append(suggestion).toString() : ""})).filter(_$9 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$9))).join("\n");
    }

    public String com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(String propDomName, String eventPropName, ReactiveHtmlElement<HTMLElement> element) {
        return "";
    }

    private final String $init$$$anonfun$2$$anonfun$1() {
        return "";
    }

    private final /* synthetic */ void $init$$$anonfun$3(ReactiveHtmlElement el, String v) {
        DomApi$.MODULE$.setValue((Element)el.ref(), v);
    }

    private final String $init$$$anonfun$4$$anonfun$1() {
        return "";
    }

    private final /* synthetic */ void $init$$$anonfun$5(ReactiveHtmlElement el, String v) {
        DomApi$.MODULE$.setValue((Element)el.ref(), v);
    }

    private final boolean $init$$$anonfun$6$$anonfun$1() {
        return false;
    }

    private final /* synthetic */ void $init$$$anonfun$7(ReactiveHtmlElement el, boolean v) {
        DomApi$.MODULE$.setChecked((Element)el.ref(), v);
    }

    private final /* synthetic */ void customConfig$$anonfun$2(HtmlProp prop$2, ReactiveHtmlElement el, Object v) {
        DomApi$.MODULE$.setHtmlProperty(el, prop$2, v);
    }

    private final InputController $anonfun$6(EventListener listener$2, KeyUpdater updater$2, ReactiveHtmlElement element$1, String propDomName$5) {
        String eventPropName = EventProcessor$.MODULE$.eventProp(listener$2.eventProcessor()).name();
        throw new Exception(this.com$raquo$laminar$inputs$InputController$$$errorMessage(((HtmlProp)updater$2.key()).name(), eventPropName, element$1, new StringBuilder(81).append("This element does not support `").append(propDomName$5).append("` controlled property in its current configuration").toString(), "Make sure you passed the right props / attributes, such as `type` for HTML inputs."));
    }

    private final InputController $anonfun$8(EventListener listener$4, ReactiveHtmlElement element$3, String propDomName$6) {
        String eventPropName = EventProcessor$.MODULE$.eventProp(listener$4.eventProcessor()).name();
        throw new Exception(this.com$raquo$laminar$inputs$InputController$$$errorMessage(propDomName$6, eventPropName, element$3, "This element does not support any controlled input props.", this.com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(propDomName$6, eventPropName, element$3)));
    }

    private final Nothing$ controlled$$anonfun$1$$anonfun$1(ReactiveHtmlElement element$5, String propDomName$7, String eventPropName$4) {
        throw new Exception(this.com$raquo$laminar$inputs$InputController$$$errorMessage(propDomName$7, eventPropName$4, element$5, "This element does not support any controlled input props.", this.com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(propDomName$7, eventPropName$4, element$5)));
    }

    private final String $anonfun$11() {
        return "";
    }
}

