/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.laminar.inputs;

import com.raquo.airstream.core.Observer;
import com.raquo.airstream.core.Observer$;
import com.raquo.airstream.core.Sink;
import com.raquo.airstream.ownership.DynamicSubscription;
import com.raquo.airstream.ownership.Owner;
import com.raquo.airstream.ownership.Subscription;
import com.raquo.ew.JsArray;
import com.raquo.ew.JsArray$;
import com.raquo.laminar.DomApi$;
import com.raquo.laminar.inputs.InputController$;
import com.raquo.laminar.keys.EventProcessor;
import com.raquo.laminar.keys.EventProcessor$;
import com.raquo.laminar.keys.EventProp;
import com.raquo.laminar.keys.HtmlProp;
import com.raquo.laminar.modifiers.Binder;
import com.raquo.laminar.modifiers.EventListener;
import com.raquo.laminar.modifiers.KeyUpdater;
import com.raquo.laminar.nodes.ReactiveElement$;
import com.raquo.laminar.nodes.ReactiveHtmlElement;
import com.raquo.laminar.tags.CustomHtmlTag;
import com.raquo.laminar.tags.Tag;
import java.io.Serializable;
import org.scalajs.dom.Element;
import org.scalajs.dom.Event;
import org.scalajs.dom.HTMLElement;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scala.scalajs.js.UndefOrOps$;
import scala.scalajs.js.internal.UnitOps$;

public class InputController<Ref extends HTMLElement, A, B> {
    private final InputControllerConfig<Ref, A> config;
    private final ReactiveHtmlElement<Ref> element;
    private final KeyUpdater<ReactiveHtmlElement<Ref>, HtmlProp<A, ?>, A> updater;
    private final EventListener<? extends Event, B> listener;
    private A prevValue;
    private final EventProcessor<Event, B> resetProcessor;

    public static <Ref extends HTMLElement> Object allowedHtmlControllerConfig(Ref Ref) {
        return InputController$.MODULE$.allowedHtmlControllerConfig(Ref);
    }

    public static <Ref extends HTMLElement, Ev extends Event, A, B> Binder<ReactiveHtmlElement<Ref>> controlled(EventListener<Ev, B> eventListener, KeyUpdater<ReactiveHtmlElement<Ref>, HtmlProp<A, ?>, A> keyUpdater) {
        return InputController$.MODULE$.controlled(eventListener, keyUpdater);
    }

    public static <A> InputControllerConfig<HTMLElement, A> customConfig(HtmlProp<A, ?> htmlProp, JsArray<EventProp<?>> jsArray, A a) {
        return InputController$.MODULE$.customConfig(htmlProp, jsArray, a);
    }

    public static JsArray<String> htmlControllableProps() {
        return InputController$.MODULE$.htmlControllableProps();
    }

    public InputController(InputControllerConfig<Ref, A> config, ReactiveHtmlElement<Ref> element, KeyUpdater<ReactiveHtmlElement<Ref>, HtmlProp<A, ?>, A> updater, EventListener<? extends Event, B> listener) {
        this.config = config;
        this.element = element;
        this.updater = updater;
        this.listener = listener;
        this.prevValue = config.initialValue();
        this.resetProcessor = listener.eventProcessor().orElseEval((Function1<Event, BoxedUnit>)(Function1 & Serializable)_$1 -> {
            this.$init$$$anonfun$1((Event)_$1);
            return BoxedUnit.UNIT;
        });
        this.setValue(config.initialValue(), true);
    }

    public String propDomName() {
        return this.updater.key().name();
    }

    public String eventPropName() {
        return EventProcessor$.MODULE$.eventProp(this.listener.eventProcessor()).name();
    }

    private void setValue(A nextValue, boolean force) {
        if (force || !BoxesRunTime.equals(nextValue, (Object)this.config.getDomValue().apply(this.element))) {
            this.config.setDomValue().apply(this.element, nextValue);
        }
        this.prevValue = nextValue;
    }

    private boolean setValue$default$2() {
        return false;
    }

    private Observer<B> combinedObserver(Owner owner) {
        ObjectRef latestSourceValue = ObjectRef.create((Object)None$.MODULE$);
        this.updater.values().foreach((Function1 & Serializable)sourceValue -> {
            this.combinedObserver$$anonfun$1(latestSourceValue, sourceValue);
            return BoxedUnit.UNIT;
        }, owner);
        Observer resetObserver = Observer$.MODULE$.apply((Function1 & Serializable)_$2 -> {
            this.$anonfun$1(latestSourceValue, _$2);
            return BoxedUnit.UNIT;
        });
        return Observer$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Observer[]{Observer$.MODULE$.apply(this.listener.callback()), resetObserver}));
    }

    public DynamicSubscription bind() {
        return ReactiveElement$.MODULE$.bindSubscriptionUnsafe(this.element, (Function1 & Serializable)ctx -> {
            this.checkControllerCompatibility();
            this.element.foreachEventListener((Function1 & Serializable)listener -> {
                this.bind$$anonfun$1$$anonfun$1((EventListener)listener);
                return BoxedUnit.UNIT;
            });
            DynamicSubscription dynSub = this.resetProcessor.$minus$minus$greater((Sink<B>)this.combinedObserver(ctx.owner())).bind(this.element, true);
            this.element.foreachEventListener((Function1 & Serializable)listener -> {
                this.bind$$anonfun$1$$anonfun$2((EventListener)listener);
                return BoxedUnit.UNIT;
            });
            return new Subscription(ctx.owner(), (Function0 & Serializable)() -> {
                dynSub.kill();
                return BoxedUnit.UNIT;
            });
        });
    }

    private void checkControllerCompatibility() {
        if (this.element.hasOtherControllerForSameProp(this)) {
            String string = this.propDomName();
            String string2 = this.eventPropName();
            throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(string, string2, this.element, new StringBuilder(36).append("Element already has a `").append(this.propDomName()).append("` controller.").toString(), InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(string, string2, this.element)));
        }
        if (this.element.hasBinderForControllableProp(this.propDomName())) {
            String string = this.propDomName();
            String string3 = this.eventPropName();
            throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(string, string3, this.element, new StringBuilder(54).append("Element already has an uncontrolled `").append(this.propDomName()).append(" <-- ???` binder.").toString(), InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(string, string3, this.element)));
        }
        if (DomApi$.MODULE$.isCustomElement((Element)this.element.ref())) {
            Tag tag = this.element.tag();
            if (tag instanceof CustomHtmlTag) {
                Object object;
                CustomHtmlTag tag2 = (CustomHtmlTag)tag;
                Object maybeAllowedConfigs = tag2.allowedControllerConfigs(this.element.ref());
                Object object2 = UnitOps$.MODULE$.unitOrOps(maybeAllowedConfigs);
                if (UndefOrOps$.MODULE$.isEmpty$extension((.bar)object2) || ((JsArray)UndefOrOps$.MODULE$.get$extension((.bar)(object = UnitOps$.MODULE$.unitOrOps(maybeAllowedConfigs)))).length() == 0) {
                    String string = this.propDomName();
                    String string4 = this.eventPropName();
                    throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(string, string4, this.element, "This element does not support any controlled props.", InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage$default$5(string, string4, this.element)));
                }
                Object object3 = UnitOps$.MODULE$.unitOrOps(maybeAllowedConfigs);
                .bar maybeMatchingPropConfig = UndefOrOps$.MODULE$.flatMap$extension((.bar)object3, (Function1 & Serializable)_$3 -> {
                    JsArray jsArray = JsArray$.MODULE$.RichJsArray(_$3);
                    Array array = Any$.MODULE$.jsArrayOps(JsArray.RichJsArray$.MODULE$.asScalaJs$extension(jsArray));
                    Option option = JSConverters$.MODULE$.JSRichOption(ArrayOps$.MODULE$.find$extension(array, (Function1 & Serializable)_$4 -> {
                        HtmlProp htmlProp = _$4.prop();
                        HtmlProp<A, ?> htmlProp2 = this.updater.key();
                        return !(htmlProp != null ? !htmlProp.equals(htmlProp2) : htmlProp2 != null);
                    }));
                    return JSConverters.JSRichOption$.MODULE$.orUndefined$extension(option);
                });
                Object object4 = UnitOps$.MODULE$.unitOrOps((Object)maybeMatchingPropConfig);
                UndefOrOps$.MODULE$.fold$extension((.bar)object4, (Function0 & Serializable)() -> {
                    this.checkControllerCompatibility$$anonfun$1(maybeAllowedConfigs);
                    return BoxedUnit.UNIT;
                }, (Function1 & Serializable)config -> {
                    this.checkControllerCompatibility$$anonfun$2((InputControllerConfig)config);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        String expectedPropName = this.config.prop().name();
        String string = this.propDomName();
        String string5 = expectedPropName;
        if (string == null ? string5 != null : !string.equals(string5)) {
            throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(this.propDomName(), this.eventPropName(), this.element, new StringBuilder(52).append("This element does not support `").append(this.propDomName()).append("` controlled property").toString(), new StringBuilder(34).append("Use `").append(expectedPropName).append("` controlled property instead").toString()));
        }
        this.checkEventPropCompatibility(this.config.allowedEventProps());
    }

    private void checkEventPropCompatibility(JsArray<EventProp<?>> expectedEventProps) {
        JsArray<EventProp<?>> expectedEventProps2 = this.config.allowedEventProps();
        JsArray jsArray = JsArray$.MODULE$.RichJsArray(expectedEventProps2);
        Array array = Any$.MODULE$.jsArrayOps(JsArray.RichJsArray$.MODULE$.asScalaJs$extension(jsArray));
        if (!ArrayOps$.MODULE$.exists$extension(array, (Function1 & Serializable)_$6 -> {
            String string = _$6.name();
            String string2 = this.eventPropName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        })) {
            String expectedEventPropNames = new StringBuilder(2).append("`").append(expectedEventProps2.map(_$7 -> _$7.name()).join("` or `")).append("`").toString();
            throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(this.propDomName(), this.eventPropName(), this.element, new StringBuilder(60).append("This element does not support `").append(this.eventPropName()).append("` event for controlled inputs").toString(), new StringBuilder(18).append("Use ").append(expectedEventPropNames).append(" event instead").toString()));
        }
    }

    private final /* synthetic */ void $init$$$anonfun$1(Event _$1) {
        this.setValue(this.prevValue, this.setValue$default$2());
    }

    private final /* synthetic */ void combinedObserver$$anonfun$1(ObjectRef latestSourceValue$1, Object sourceValue) {
        Some some = Some$.MODULE$.apply(sourceValue);
        latestSourceValue$1.elem = some;
        some = null;
        this.setValue(sourceValue, this.setValue$default$2());
    }

    private final Object $anonfun$1$$anonfun$1() {
        return this.prevValue;
    }

    private final /* synthetic */ void $anonfun$1(ObjectRef latestSourceValue$2, Object _$2) {
        this.setValue(((Option)latestSourceValue$2.elem).getOrElse(this::$anonfun$1$$anonfun$1), this.setValue$default$2());
    }

    private final /* synthetic */ void bind$$anonfun$1$$anonfun$1(EventListener listener) {
        DomApi$.MODULE$.removeEventListener((Element)this.element.ref(), listener);
    }

    private final /* synthetic */ void bind$$anonfun$1$$anonfun$2(EventListener listener) {
        DomApi$.MODULE$.addEventListener((Element)this.element.ref(), listener);
    }

    private final void checkControllerCompatibility$$anonfun$1(Object maybeAllowedConfigs$1) {
        Object object = UnitOps$.MODULE$.unitOrOps(maybeAllowedConfigs$1);
        String expectedPropNames = new StringBuilder(2).append("`").append(((JsArray)UndefOrOps$.MODULE$.get$extension((.bar)object)).map(_$5 -> _$5.prop().name()).join("` or `")).append("`").toString();
        throw new Exception(InputController$.MODULE$.com$raquo$laminar$inputs$InputController$$$errorMessage(this.propDomName(), this.eventPropName(), this.element, new StringBuilder(52).append("This element does not support `").append(this.propDomName()).append("` controlled property").toString(), new StringBuilder(32).append("Use ").append(expectedPropNames).append(" controlled property instead").toString()));
    }

    private final /* synthetic */ void checkControllerCompatibility$$anonfun$2(InputControllerConfig config) {
        this.checkEventPropCompatibility(config.allowedEventProps());
    }

    public static final class InputControllerConfig<Ref extends HTMLElement, A> {
        private final Object initialValue;
        private final HtmlProp prop;
        private final JsArray allowedEventProps;
        private final Function1 getDomValue;
        private final Function2 setDomValue;

        public InputControllerConfig(A initialValue, HtmlProp<A, ?> prop, JsArray<EventProp<?>> allowedEventProps, Function1<ReactiveHtmlElement<Ref>, A> getDomValue, Function2<ReactiveHtmlElement<Ref>, A, BoxedUnit> setDomValue) {
            this.initialValue = initialValue;
            this.prop = prop;
            this.allowedEventProps = allowedEventProps;
            this.getDomValue = getDomValue;
            this.setDomValue = setDomValue;
        }

        public A initialValue() {
            return (A)this.initialValue;
        }

        public HtmlProp<A, ?> prop() {
            return this.prop;
        }

        public JsArray<EventProp<?>> allowedEventProps() {
            return this.allowedEventProps;
        }

        public Function1<ReactiveHtmlElement<Ref>, A> getDomValue() {
            return this.getDomValue;
        }

        public Function2<ReactiveHtmlElement<Ref>, A, BoxedUnit> setDomValue() {
            return this.setDomValue;
        }
    }
}

