/*
 * Decompiled with CFR 0.152.
 */
package com.raskasa.metrics.okhttp;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Response;

final class InstrumentedInterceptor
implements Interceptor {
    private final Meter submitted;
    private final Counter running;
    private final Meter completed;
    private final Timer duration;

    InstrumentedInterceptor(MetricRegistry registry, String name) {
        this.submitted = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"network-requests-submitted"}));
        this.running = registry.counter(MetricRegistry.name((String)name, (String[])new String[]{"network-requests-running"}));
        this.completed = registry.meter(MetricRegistry.name((String)name, (String[])new String[]{"network-requests-completed"}));
        this.duration = registry.timer(MetricRegistry.name((String)name, (String[])new String[]{"network-requests-duration"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        this.submitted.mark();
        this.running.inc();
        Timer.Context context = this.duration.time();
        try {
            Response response = chain.proceed(chain.request());
            return response;
        }
        finally {
            context.stop();
            this.running.dec();
            this.completed.mark();
        }
    }
}

