/*
 * Decompiled with CFR 0.152.
 */
package com.raskasa.metrics.okhttp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.raskasa.metrics.okhttp.InstrumentedInterceptor;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InstrumentedOkHttpClient
extends OkHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentedOkHttpClient.class);
    private final MetricRegistry registry;
    private OkHttpClient rawClient;
    private final String name;

    InstrumentedOkHttpClient(MetricRegistry registry, OkHttpClient rawClient, String name) {
        this.rawClient = rawClient;
        this.registry = registry;
        this.name = name;
        this.instrumentHttpCache();
        this.instrumentConnectionPool();
        this.instrumentNetworkRequests();
    }

    String metricId(String metric) {
        return MetricRegistry.name(OkHttpClient.class, (String[])new String[]{this.name, metric});
    }

    private void instrumentHttpCache() {
        if (this.cache() == null) {
            return;
        }
        this.registry.register(this.metricId("cache-request-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().requestCount();
            }
        });
        this.registry.register(this.metricId("cache-hit-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().hitCount();
            }
        });
        this.registry.register(this.metricId("cache-network-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().networkCount();
            }
        });
        this.registry.register(this.metricId("cache-write-success-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().writeSuccessCount();
            }
        });
        this.registry.register(this.metricId("cache-write-abort-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().writeAbortCount();
            }
        });
        Gauge<Long> currentCacheSize = new Gauge<Long>(){

            public Long getValue() {
                try {
                    return InstrumentedOkHttpClient.this.rawClient.cache().size();
                }
                catch (IOException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    return -1L;
                }
            }
        };
        Gauge<Long> maxCacheSize = new Gauge<Long>(){

            public Long getValue() {
                return InstrumentedOkHttpClient.this.rawClient.cache().maxSize();
            }
        };
        this.registry.register(this.metricId("cache-current-size"), (Metric)currentCacheSize);
        this.registry.register(this.metricId("cache-max-size"), (Metric)maxCacheSize);
        this.registry.register(this.metricId("cache-size"), (Metric)new RatioGauge((Gauge)currentCacheSize, (Gauge)maxCacheSize){
            final /* synthetic */ Gauge val$currentCacheSize;
            final /* synthetic */ Gauge val$maxCacheSize;
            {
                this.val$currentCacheSize = gauge;
                this.val$maxCacheSize = gauge2;
            }

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)((Long)this.val$currentCacheSize.getValue()).longValue(), (double)((Long)this.val$maxCacheSize.getValue()).longValue());
            }
        });
    }

    private void instrumentConnectionPool() {
        if (this.connectionPool() == null) {
            this.rawClient = this.rawClient.newBuilder().connectionPool(new ConnectionPool()).build();
        }
        this.registry.register(this.metricId("connection-pool-total-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.connectionPool().connectionCount();
            }
        });
        this.registry.register(this.metricId("connection-pool-idle-count"), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return InstrumentedOkHttpClient.this.rawClient.connectionPool().idleConnectionCount();
            }
        });
    }

    private void instrumentNetworkRequests() {
        this.rawClient = this.rawClient.newBuilder().addNetworkInterceptor((Interceptor)new InstrumentedInterceptor(this.registry, MetricRegistry.name(OkHttpClient.class, (String[])new String[]{this.name}))).build();
    }

    public Authenticator authenticator() {
        return this.rawClient.authenticator();
    }

    public Cache cache() {
        return this.rawClient.cache();
    }

    public CertificatePinner certificatePinner() {
        return this.rawClient.certificatePinner();
    }

    public ConnectionPool connectionPool() {
        return this.rawClient.connectionPool();
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.rawClient.connectionSpecs();
    }

    public int connectTimeoutMillis() {
        return this.rawClient.connectTimeoutMillis();
    }

    public CookieJar cookieJar() {
        return this.rawClient.cookieJar();
    }

    public Dispatcher dispatcher() {
        return this.rawClient.dispatcher();
    }

    public Dns dns() {
        return this.rawClient.dns();
    }

    public boolean followRedirects() {
        return this.rawClient.followRedirects();
    }

    public boolean followSslRedirects() {
        return this.rawClient.followSslRedirects();
    }

    public HostnameVerifier hostnameVerifier() {
        return this.rawClient.hostnameVerifier();
    }

    public List<Interceptor> interceptors() {
        return this.rawClient.interceptors();
    }

    public List<Interceptor> networkInterceptors() {
        return this.rawClient.networkInterceptors();
    }

    public OkHttpClient.Builder newBuilder() {
        return this.rawClient.newBuilder();
    }

    public Call newCall(Request request) {
        return this.rawClient.newCall(request);
    }

    public WebSocket newWebSocket(Request request, WebSocketListener listener) {
        return this.rawClient.newWebSocket(request, listener);
    }

    public int pingIntervalMillis() {
        return this.rawClient.pingIntervalMillis();
    }

    public List<Protocol> protocols() {
        return this.rawClient.protocols();
    }

    public Proxy proxy() {
        return this.rawClient.proxy();
    }

    public Authenticator proxyAuthenticator() {
        return this.rawClient.proxyAuthenticator();
    }

    public ProxySelector proxySelector() {
        return this.rawClient.proxySelector();
    }

    public int readTimeoutMillis() {
        return this.rawClient.readTimeoutMillis();
    }

    public boolean retryOnConnectionFailure() {
        return this.rawClient.retryOnConnectionFailure();
    }

    public SocketFactory socketFactory() {
        return this.rawClient.socketFactory();
    }

    public SSLSocketFactory sslSocketFactory() {
        return this.rawClient.sslSocketFactory();
    }

    public int writeTimeoutMillis() {
        return this.rawClient.writeTimeoutMillis();
    }

    public boolean equals(Object obj) {
        return obj instanceof InstrumentedOkHttpClient && this.rawClient.equals(((InstrumentedOkHttpClient)((Object)obj)).rawClient) || this.rawClient.equals(obj);
    }

    public String toString() {
        return this.rawClient.toString();
    }
}

