/*
 * Decompiled with CFR 0.152.
 */
package com.rationaleemotions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.rationaleemotions.GridApiException;
import com.rationaleemotions.IndividualCapabilityDeserializer;
import com.rationaleemotions.SimpleHttpClient;
import com.rationaleemotions.pojos.Host;
import com.rationaleemotions.pojos.HubConfiguration;
import com.rationaleemotions.pojos.IndividualCapability;
import com.rationaleemotions.pojos.NodeConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.openqa.selenium.io.Zip;

public class GridApiAssistant {
    private static final String API_PROXY = "http://%s:%d/grid/api/proxy/?id=%s";
    private static final String API_HUB = "http://%s:%d/grid/api/hub/";
    private static final String API_TESTSESSION = "http://%s:%d/grid/api/testsession?session=%s";
    private static final String API_UPLOAD = "http://%s:%d/wd/hub/session/%s/file";
    private Host grid;
    private Gson gson;

    public GridApiAssistant(Host grid) {
        this.grid = grid;
        this.gson = new GsonBuilder().registerTypeAdapter(IndividualCapabilityDeserializer.getAdaptor(), (Object)new IndividualCapabilityDeserializer()).create();
    }

    public Host getNodeDetailsForSession(String sessionId) {
        try {
            URL url = new URL(String.format(API_TESTSESSION, this.grid.getIpAddress(), this.grid.getPort(), sessionId));
            JsonObject object = SimpleHttpClient.get(url);
            return new Host(object.get("proxyId").getAsString());
        }
        catch (MalformedURLException e) {
            throw new GridApiException(e);
        }
    }

    public NodeConfiguration getNodeConfigForSession(Host node) {
        try {
            String id = String.format("http://%s:%s", node.getIpAddress(), node.getPort());
            URL url = new URL(String.format(API_PROXY, this.grid.getIpAddress(), this.grid.getPort(), id));
            JsonObject object = SimpleHttpClient.get(url);
            boolean success = object.get("success").getAsBoolean();
            if (!success) {
                throw new IllegalArgumentException(object.get("msg").getAsString());
            }
            JsonObject request = object.get("request").getAsJsonObject();
            JsonObject config = request.get("configuration").getAsJsonObject();
            NodeConfiguration data = (NodeConfiguration)this.gson.fromJson((JsonElement)config, NodeConfiguration.class);
            if (request.has("capabilities")) {
                List caps = (List)this.gson.fromJson(request.get("capabilities"), new TypeToken<List<IndividualCapability>>(){}.getType());
                data.setCapabilities(caps);
            }
            data.setId(object.get("id").getAsString());
            return data;
        }
        catch (MalformedURLException e) {
            throw new GridApiException(e);
        }
    }

    public HubConfiguration getHubConfiguration() {
        try {
            URL url = new URL(String.format(API_HUB, this.grid.getIpAddress(), this.grid.getPort()));
            JsonObject object = SimpleHttpClient.get(url);
            return (HubConfiguration)this.gson.fromJson((JsonElement)object, HubConfiguration.class);
        }
        catch (MalformedURLException e) {
            throw new GridApiException(e);
        }
    }

    public String uploadFileToNode(String sessionId, File file) {
        try {
            URL url = new URL(String.format(API_UPLOAD, this.grid.getIpAddress(), this.grid.getPort(), sessionId));
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("file", this.asString(file));
            return SimpleHttpClient.post(url, parameters).get("value").getAsString();
        }
        catch (MalformedURLException e) {
            throw new GridApiException(e);
        }
    }

    private String asString(File localFile) {
        if (!localFile.isFile()) {
            throw new GridApiException("You may only upload files: " + localFile);
        }
        try {
            return Zip.zip((File)localFile);
        }
        catch (IOException e) {
            throw new GridApiException("Cannot upload " + localFile, e);
        }
    }
}

