/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.Customer;
import com.razorpay.RazorpayException;
import com.razorpay.Token;
import java.util.List;
import org.json.JSONObject;

public class CustomerClient
extends ApiClient {
    CustomerClient(String auth) {
        super(auth);
    }

    public Customer create(JSONObject request) throws RazorpayException {
        return (Customer)this.post("customers", request);
    }

    public Customer fetch(String id) throws RazorpayException {
        return (Customer)this.get(String.format("customers/%s", id), null);
    }

    public Customer edit(String id, JSONObject request) throws RazorpayException {
        return (Customer)this.put(String.format("customers/%s", id), request);
    }

    public List<Token> fetchTokens(String id) throws RazorpayException {
        return this.getCollection(String.format("customers/%s/tokens", id), null);
    }

    public Token fetchToken(String id, String tokenId) throws RazorpayException {
        return (Token)this.get(String.format("customers/%s/tokens/%s", id, tokenId), null);
    }

    public void deleteToken(String id, String tokenId) throws RazorpayException {
        this.delete(String.format("customers/%s/tokens/%s", id, tokenId), null);
    }
}

