/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiUtils;
import com.razorpay.Entity;
import com.razorpay.EntityNameURLMapping;
import com.razorpay.RazorpayException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import okhttp3.HttpUrl;
import okhttp3.Response;
import org.apache.commons.text.WordUtils;
import org.json.JSONArray;
import org.json.JSONObject;

class ApiClient {
    String auth;
    private final String ENTITY = "entity";
    private final String COLLECTION = "collection";
    private final String ERROR = "error";
    private final String DESCRIPTION = "description";
    private final String STATUS_CODE = "code";
    private final int STATUS_OK = 200;
    private final int STATUS_MULTIPLE_CHOICE = 300;

    ApiClient(String auth) {
        this.auth = auth;
    }

    public <T extends Entity> T get(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.getRequest(version, path, requestObject, this.auth);
        return (T)((Entity)this.processResponse(response));
    }

    public <T> T post(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.postRequest(version, path, requestObject, this.auth);
        return this.processResponse(response);
    }

    public <T extends Entity> T put(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.putRequest(version, path, requestObject, this.auth);
        return (T)((Entity)this.processResponse(response));
    }

    public <T extends Entity> T patch(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.patchRequest(version, path, requestObject, this.auth);
        return (T)((Entity)this.processResponse(response));
    }

    <T extends Entity> ArrayList<T> getCollection(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.getRequest(version, path, requestObject, this.auth);
        return this.processCollectionResponse(response);
    }

    public <T> T delete(String version, String path, JSONObject requestObject) throws RazorpayException {
        Response response = ApiUtils.deleteRequest(version, path, requestObject, this.auth);
        return this.processDeleteResponse(response);
    }

    private <T> T processDeleteResponse(Response response) throws RazorpayException {
        if (response == null) {
            throw new RazorpayException("Invalid Response from server");
        }
        int statusCode = response.code();
        String responseBody = null;
        JSONObject responseJson = null;
        try {
            responseBody = response.body().string();
            if (responseBody.equals("[]")) {
                return (T)Collections.emptyList();
            }
            if (response.code() == 204) {
                return null;
            }
            responseJson = new JSONObject(responseBody);
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
        if (statusCode < 200 || statusCode >= 300) {
            this.throwException(statusCode, responseJson);
        }
        return this.parseResponse(responseJson, this.getEntity(responseJson, response.request().url()));
    }

    private <T extends Entity> T parseResponse(JSONObject jsonObject, String entity) throws RazorpayException {
        if (entity != null) {
            Class cls = this.getClass(entity);
            try {
                return (T)((Entity)cls.getConstructor(JSONObject.class).newInstance(jsonObject));
            }
            catch (Exception e) {
                throw new RazorpayException("Unable to parse response because of " + e.getMessage());
            }
        }
        throw new RazorpayException("Unable to parse response");
    }

    private <T extends Entity> ArrayList<T> parseCollectionResponse(JSONArray jsonArray, HttpUrl requestUrl) throws RazorpayException {
        ArrayList<T> modelList = new ArrayList<T>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObj = jsonArray.getJSONObject(i);
            T t = this.parseResponse(jsonObj, this.getEntity(jsonObj, requestUrl));
            modelList.add(t);
        }
        return modelList;
    }

    private String getEntityNameFromURL(HttpUrl url) {
        String param = (String)url.pathSegments().get(1);
        return EntityNameURLMapping.getEntityName(param);
    }

    <T> T processResponse(Response response) throws RazorpayException {
        if (response == null) {
            throw new RazorpayException("Invalid Response from server");
        }
        int statusCode = response.code();
        String responseBody = null;
        JSONObject responseJson = null;
        try {
            responseBody = response.body().string();
            if (responseBody.equals("[]")) {
                return (T)Collections.emptyList();
            }
            responseJson = new JSONObject(responseBody);
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
        if (statusCode >= 200 && statusCode < 300) {
            return this.parseResponse(responseJson, this.getEntity(responseJson, response.request().url()));
        }
        this.throwException(statusCode, responseJson);
        return null;
    }

    <T extends Entity> ArrayList<T> processCollectionResponse(Response response) throws RazorpayException {
        if (response == null) {
            throw new RazorpayException("Invalid Response from server");
        }
        int statusCode = response.code();
        String responseBody = null;
        JSONObject responseJson = null;
        try {
            responseBody = response.body().string();
            responseJson = new JSONObject(responseBody);
        }
        catch (IOException e) {
            throw new RazorpayException(e.getMessage());
        }
        String collectionName = null;
        String string = collectionName = responseJson.has("payment_links") ? "payment_links" : "items";
        if (statusCode >= 200 && statusCode < 300) {
            return this.parseCollectionResponse(responseJson.getJSONArray(collectionName), response.request().url());
        }
        this.throwException(statusCode, responseJson);
        return null;
    }

    private String getEntity(JSONObject jsonObj, HttpUrl url) {
        if (!jsonObj.has("entity")) {
            return this.getEntityNameFromURL(url);
        }
        if (this.getClass(jsonObj.get("entity").toString()) == null) {
            return this.getEntityNameFromURL(url);
        }
        return jsonObj.getString("entity");
    }

    private void throwException(int statusCode, JSONObject responseJson) throws RazorpayException {
        if (responseJson.has("error")) {
            JSONObject errorResponse = responseJson.getJSONObject("error");
            String code = errorResponse.getString("code");
            String description = errorResponse.getString("description");
            throw new RazorpayException(code + ":" + description);
        }
        this.throwServerException(statusCode, responseJson.toString());
    }

    private void throwServerException(int statusCode, String responseBody) throws RazorpayException {
        StringBuilder sb = new StringBuilder();
        sb.append("Status Code: ").append(statusCode).append("\n");
        sb.append("Server response: ").append(responseBody);
        throw new RazorpayException(sb.toString());
    }

    private Class getClass(String entity) {
        try {
            String entityClass = "com.razorpay." + WordUtils.capitalize((String)entity, (char[])new char[]{'_'}).replaceAll("_", "");
            return Class.forName(entityClass);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

