/*
 * Decompiled with CFR 0.152.
 */
package com.reactific.helpers;

import com.reactific.helpers.DateTimeHelpers;
import java.time.Instant;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DateTimeHelpers$ {
    public static DateTimeHelpers$ MODULE$;
    private final long millisPerSecond;
    private final long millisPerMinute;
    private final long millisPerHour;
    private final long millisPerDay;
    private final long millisPerYear;

    static {
        new DateTimeHelpers$();
    }

    public String dateStr(long millis) {
        return this.dateStr(Instant.ofEpochMilli(millis));
    }

    public String dateStr(Instant dt) {
        return DateTimeFormatter.ISO_INSTANT.format(dt);
    }

    public DateTimeHelpers.StringBuilderPimps StringBuilderPimps(StringBuilder bldr) {
        return new DateTimeHelpers.StringBuilderPimps(bldr);
    }

    public String makeReadable(Period period) {
        StringBuilder builder = new StringBuilder();
        Object object = period.getYears() > 0 ? this.StringBuilderPimps(builder).appendSuffix(period.getYears(), "year") : BoxedUnit.UNIT;
        Object object2 = period.getMonths() > 0 ? this.StringBuilderPimps(builder).appendSuffix(period.getMonths(), "month") : BoxedUnit.UNIT;
        Object object3 = period.getDays() > 0 ? this.StringBuilderPimps(builder).appendSuffix(period.getDays(), "day") : BoxedUnit.UNIT;
        return (String)new StringOps(Predef$.MODULE$.augmentString(builder.toString())).dropRight(2);
    }

    public long millisPerSecond() {
        return this.millisPerSecond;
    }

    public long millisPerMinute() {
        return this.millisPerMinute;
    }

    public long millisPerHour() {
        return this.millisPerHour;
    }

    public long millisPerDay() {
        return this.millisPerDay;
    }

    public long millisPerYear() {
        return this.millisPerYear;
    }

    public String makeReadable(java.time.Duration duration) {
        StringBuilder stringBuilder;
        long num_minutes;
        long num_hours;
        long num_days;
        StringBuilder builder = new StringBuilder();
        long duration_in_millis = duration.toMillis();
        long num_years = duration_in_millis / this.millisPerYear();
        if (num_years > 0L) {
            this.StringBuilderPimps(builder).appendSuffix(num_years, "year");
            duration_in_millis -= num_years * this.millisPerYear();
        }
        if ((num_days = duration_in_millis / this.millisPerDay()) > 0L) {
            this.StringBuilderPimps(builder).appendSuffix(num_days, "day");
            duration_in_millis -= num_days * this.millisPerDay();
        }
        if ((num_hours = duration_in_millis / this.millisPerHour()) > 0L) {
            this.StringBuilderPimps(builder).appendSuffix(num_hours, "hour");
            duration_in_millis -= num_hours * this.millisPerHour();
        }
        if ((num_minutes = duration_in_millis / this.millisPerMinute()) > 0L) {
            this.StringBuilderPimps(builder).appendSuffix(num_minutes, "minute");
            duration_in_millis -= num_minutes * this.millisPerMinute();
        }
        if (duration_in_millis >= this.millisPerSecond()) {
            double num_seconds;
            double arg$macro$1 = num_seconds = (double)duration_in_millis / (double)this.millisPerSecond();
            stringBuilder = builder.append(new StringOps("%2.3f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}))).append(num_seconds == 1.0 ? " second, " : " seconds, ");
        } else {
            stringBuilder = builder.append(duration_in_millis).append(" ms, ");
        }
        return (String)new StringOps(Predef$.MODULE$.augmentString(builder.toString())).dropRight(2);
    }

    public String makeReadable(Duration duration) {
        return this.makeReadable(java.time.Duration.ofNanos(duration.toNanos()));
    }

    private DateTimeHelpers$() {
        MODULE$ = this;
        this.millisPerSecond = 1000L;
        this.millisPerMinute = 60L * this.millisPerSecond();
        this.millisPerHour = 60L * this.millisPerMinute();
        this.millisPerDay = 24L * this.millisPerHour();
        this.millisPerYear = this.millisPerDay() * 365L;
    }
}

