/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.data;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import com.readystatesoftware.chuck.internal.data.ChuckDbOpenHelper;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.data.LocalCupboard;

public class ChuckContentProvider
extends ContentProvider {
    public static Uri TRANSACTION_URI;
    private static final int TRANSACTION = 0;
    private static final int TRANSACTIONS = 1;
    private static UriMatcher matcher;
    private ChuckDbOpenHelper databaseHelper;

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        TRANSACTION_URI = Uri.parse((String)("content://" + info.authority + "/transaction"));
        matcher.addURI(info.authority, "transaction/#", 0);
        matcher.addURI(info.authority, "transaction", 1);
    }

    public boolean onCreate() {
        this.databaseHelper = new ChuckDbOpenHelper(this.getContext());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        Cursor cursor = null;
        switch (matcher.match(uri)) {
            case 1: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(HttpTransaction.class).withProjection(projection).withSelection(selection, selectionArgs).orderBy(sortOrder).getCursor();
                break;
            }
            case 0: {
                cursor = LocalCupboard.getInstance().withDatabase(db).query(HttpTransaction.class).byId(ContentUris.parseId((Uri)uri)).getCursor();
            }
        }
        if (cursor != null) {
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        }
        return cursor;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        switch (matcher.match(uri)) {
            case 1: {
                long id = db.insert(LocalCupboard.getInstance().getTable(HttpTransaction.class), null, contentValues);
                if (id <= 0L) break;
                this.getContext().getContentResolver().notifyChange(uri, null);
                return ContentUris.withAppendedId((Uri)TRANSACTION_URI, (long)id);
            }
        }
        return null;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int result = 0;
        switch (matcher.match(uri)) {
            case 1: {
                result = db.delete(LocalCupboard.getInstance().getTable(HttpTransaction.class), selection, selectionArgs);
                break;
            }
            case 0: {
                result = db.delete(LocalCupboard.getInstance().getTable(HttpTransaction.class), "_id = ?", new String[]{(String)uri.getPathSegments().get(1)});
            }
        }
        if (result > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return result;
    }

    public int update(Uri uri, ContentValues contentValues, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        int result = 0;
        switch (matcher.match(uri)) {
            case 1: {
                result = db.update(LocalCupboard.getInstance().getTable(HttpTransaction.class), contentValues, selection, selectionArgs);
                break;
            }
            case 0: {
                result = db.update(LocalCupboard.getInstance().getTable(HttpTransaction.class), contentValues, "_id = ?", new String[]{(String)uri.getPathSegments().get(1)});
            }
        }
        if (result > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return result;
    }

    static {
        matcher = new UriMatcher(-1);
    }
}

