/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.support;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationCompat;
import android.util.LongSparseArray;
import com.readystatesoftware.chuck.Chuck;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.support.ClearTransactionsService;
import com.readystatesoftware.chuck.internal.ui.BaseChuckActivity;

public class NotificationHelper {
    private static final int NOTIFICATION_ID = 1138;
    private static final int BUFFER_SIZE = 10;
    private static LongSparseArray<HttpTransaction> transactionBuffer = new LongSparseArray();
    private static int transactionCount;
    private Context context;
    private NotificationManager notificationManager;

    public static synchronized void clearBuffer() {
        transactionBuffer.clear();
        transactionCount = 0;
    }

    private static synchronized void addToBuffer(HttpTransaction transaction) {
        if (transaction.getStatus() == HttpTransaction.Status.Requested) {
            ++transactionCount;
        }
        transactionBuffer.put(transaction.getId().longValue(), (Object)transaction);
        if (transactionBuffer.size() > 10) {
            transactionBuffer.removeAt(0);
        }
    }

    public NotificationHelper(Context context) {
        this.context = context;
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    public synchronized void show(HttpTransaction transaction) {
        NotificationHelper.addToBuffer(transaction);
        if (!BaseChuckActivity.isInForeground()) {
            NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this.context).setContentIntent(PendingIntent.getActivity((Context)this.context, (int)0, (Intent)Chuck.getLaunchIntent(this.context), (int)0)).setSmallIcon(R.drawable.chuck_ic_notification_white_24dp).setColor(this.context.getResources().getColor(R.color.chuck_colorPrimary)).setContentTitle((CharSequence)this.context.getString(R.string.chuck_notification_title));
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            int count = 0;
            for (int i = transactionBuffer.size() - 1; i >= 0; --i) {
                if (count < 10) {
                    if (count == 0) {
                        mBuilder.setContentText((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                    }
                    inboxStyle.addLine((CharSequence)((HttpTransaction)transactionBuffer.valueAt(i)).getNotificationText());
                }
                ++count;
            }
            mBuilder.setAutoCancel(true);
            mBuilder.setStyle((NotificationCompat.Style)inboxStyle);
            if (Build.VERSION.SDK_INT >= 24) {
                mBuilder.setSubText((CharSequence)String.valueOf(transactionCount));
            } else {
                mBuilder.setNumber(transactionCount);
            }
            mBuilder.addAction(this.getClearAction());
            this.notificationManager.notify(1138, mBuilder.build());
        }
    }

    @NonNull
    private NotificationCompat.Action getClearAction() {
        String clearTitle = this.context.getString(R.string.chuck_clear);
        Intent deleteIntent = new Intent(this.context, ClearTransactionsService.class);
        PendingIntent intent = PendingIntent.getService((Context)this.context, (int)11, (Intent)deleteIntent, (int)0x40000000);
        return new NotificationCompat.Action(R.drawable.chuck_ic_delete_white_24dp, (CharSequence)clearTitle, intent);
    }

    public void dismiss() {
        this.notificationManager.cancel(1138);
    }
}

