/*
 * Decompiled with CFR 0.152.
 */
package com.readystatesoftware.chuck.internal.ui;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.readystatesoftware.chuck.R;
import com.readystatesoftware.chuck.internal.data.HttpTransaction;
import com.readystatesoftware.chuck.internal.ui.TransactionFragment;

public class TransactionOverviewFragment
extends Fragment
implements TransactionFragment {
    TextView url;
    TextView method;
    TextView protocol;
    TextView status;
    TextView response;
    TextView ssl;
    TextView requestTime;
    TextView responseTime;
    TextView duration;
    TextView requestSize;
    TextView responseSize;
    TextView totalSize;
    private HttpTransaction transaction;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.chuck_fragment_transaction_overview, container, false);
        this.url = (TextView)view.findViewById(R.id.url);
        this.method = (TextView)view.findViewById(R.id.method);
        this.protocol = (TextView)view.findViewById(R.id.protocol);
        this.status = (TextView)view.findViewById(R.id.status);
        this.response = (TextView)view.findViewById(R.id.response);
        this.ssl = (TextView)view.findViewById(R.id.ssl);
        this.requestTime = (TextView)view.findViewById(R.id.request_time);
        this.responseTime = (TextView)view.findViewById(R.id.response_time);
        this.duration = (TextView)view.findViewById(R.id.duration);
        this.requestSize = (TextView)view.findViewById(R.id.request_size);
        this.responseSize = (TextView)view.findViewById(R.id.response_size);
        this.totalSize = (TextView)view.findViewById(R.id.total_size);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.populateUI();
    }

    @Override
    public void transactionUpdated(HttpTransaction transaction) {
        this.transaction = transaction;
        this.populateUI();
    }

    private void populateUI() {
        if (this.isAdded() && this.transaction != null) {
            this.url.setText((CharSequence)this.transaction.getUrl());
            this.method.setText((CharSequence)this.transaction.getMethod());
            this.protocol.setText((CharSequence)this.transaction.getProtocol());
            this.status.setText((CharSequence)this.transaction.getStatus().toString());
            this.response.setText((CharSequence)this.transaction.getResponseSummaryText());
            this.ssl.setText(this.transaction.isSsl() ? R.string.chuck_yes : R.string.chuck_no);
            this.requestTime.setText((CharSequence)this.transaction.getRequestDateString());
            this.responseTime.setText((CharSequence)this.transaction.getResponseDateString());
            this.duration.setText((CharSequence)this.transaction.getDurationString());
            this.requestSize.setText((CharSequence)this.transaction.getRequestSizeString());
            this.responseSize.setText((CharSequence)this.transaction.getResponseSizeString());
            this.totalSize.setText((CharSequence)this.transaction.getTotalSizeString());
        }
    }
}

