/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client.api_requests;

import com.recombee.api_client.api_requests.Request;
import com.recombee.api_client.util.HTTPMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Batch
extends Request {
    protected List<Request> requests;
    protected boolean distinctRecomms;

    public Batch(List<Request> requests) {
        this.initialize(requests);
    }

    public Batch(Request[] requests) {
        this.initialize(Arrays.asList(requests));
    }

    private void initialize(List<Request> requests) {
        this.requests = requests;
        this.distinctRecomms = false;
        this.timeout = 0L;
        for (Request r : this.requests) {
            this.timeout += r.getTimeout();
        }
    }

    public List<Request> getRequests() {
        return this.requests;
    }

    public Batch setDistinctRecomms(boolean distinctRecomms) {
        this.distinctRecomms = distinctRecomms;
        return this;
    }

    public boolean getDistinctRecomms() {
        return this.distinctRecomms;
    }

    @Override
    public HTTPMethod getHTTPMethod() {
        return HTTPMethod.POST;
    }

    @Override
    public boolean getEnsureHttps() {
        return true;
    }

    @Override
    public String getPath() {
        return "/batch/";
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, Object> getBodyParameters() {
        ArrayList<Map<String, Object>> requestMaps = new ArrayList<Map<String, Object>>();
        for (Request r : this.requests) {
            requestMaps.add(this.requestToBatchMap(r));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("requests", requestMaps);
        result.put("distinctRecomms", this.distinctRecomms);
        return result;
    }

    protected Map<String, Object> requestToBatchMap(Request req) {
        HashMap<String, Object> bm = new HashMap<String, Object>();
        bm.put("path", req.getPath());
        bm.put("method", req.getHTTPMethod().name());
        Map<String, Object> params = req.getQueryParameters();
        params.putAll(req.getBodyParameters());
        if (params.size() > 0) {
            bm.put("params", params);
        }
        return bm;
    }
}

