/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client.api_requests;

import com.recombee.api_client.api_requests.Request;
import com.recombee.api_client.util.HTTPMethod;
import java.util.HashMap;
import java.util.Map;

public class MergeUsers
extends Request {
    protected String targetUserId;
    protected String sourceUserId;
    protected Boolean cascadeCreate;

    public MergeUsers(String targetUserId, String sourceUserId) {
        this.targetUserId = targetUserId;
        this.sourceUserId = sourceUserId;
        this.timeout = 10000L;
    }

    public MergeUsers setCascadeCreate(boolean cascadeCreate) {
        this.cascadeCreate = cascadeCreate;
        return this;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public String getSourceUserId() {
        return this.sourceUserId;
    }

    public boolean getCascadeCreate() {
        if (this.cascadeCreate == null) {
            return false;
        }
        return this.cascadeCreate;
    }

    @Override
    public HTTPMethod getHTTPMethod() {
        return HTTPMethod.PUT;
    }

    @Override
    public String getPath() {
        return String.format("/users/%s/merge/%s", this.targetUserId, this.sourceUserId);
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.cascadeCreate != null) {
            params.put("cascadeCreate", this.cascadeCreate.toString());
        }
        return params;
    }

    @Override
    public Map<String, Object> getBodyParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return params;
    }
}

