/*
 * Decompiled with CFR 0.152.
 */
package com.recombee.api_client.api_requests;

import com.recombee.api_client.api_requests.Request;
import com.recombee.api_client.bindings.Logic;
import com.recombee.api_client.util.HTTPMethod;
import java.util.HashMap;
import java.util.Map;

public class SearchItemSegments
extends Request {
    protected String userId;
    protected String searchQuery;
    protected Long count;
    protected String scenario;
    protected Boolean cascadeCreate;
    protected String filter;
    protected String booster;
    protected Logic logic;
    protected Map<String, Object> expertSettings;
    protected Boolean returnAbGroup;

    public SearchItemSegments(String userId, String searchQuery, long count) {
        this.userId = userId;
        this.searchQuery = searchQuery;
        this.count = count;
        this.timeout = 3000L;
    }

    public SearchItemSegments setScenario(String scenario) {
        this.scenario = scenario;
        return this;
    }

    public SearchItemSegments setCascadeCreate(boolean cascadeCreate) {
        this.cascadeCreate = cascadeCreate;
        return this;
    }

    public SearchItemSegments setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public SearchItemSegments setBooster(String booster) {
        this.booster = booster;
        return this;
    }

    public SearchItemSegments setLogic(Logic logic) {
        this.logic = logic;
        return this;
    }

    public SearchItemSegments setExpertSettings(Map<String, Object> expertSettings) {
        this.expertSettings = expertSettings;
        return this;
    }

    public SearchItemSegments setReturnAbGroup(boolean returnAbGroup) {
        this.returnAbGroup = returnAbGroup;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public long getCount() {
        return this.count;
    }

    public String getScenario() {
        return this.scenario;
    }

    public boolean getCascadeCreate() {
        if (this.cascadeCreate == null) {
            return false;
        }
        return this.cascadeCreate;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getBooster() {
        return this.booster;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public Map<String, Object> getExpertSettings() {
        return this.expertSettings;
    }

    public boolean getReturnAbGroup() {
        if (this.returnAbGroup == null) {
            return false;
        }
        return this.returnAbGroup;
    }

    @Override
    public HTTPMethod getHTTPMethod() {
        return HTTPMethod.POST;
    }

    @Override
    public String getPath() {
        return String.format("/search/users/%s/item-segments/", this.userId);
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return params;
    }

    @Override
    public Map<String, Object> getBodyParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("searchQuery", this.searchQuery);
        params.put("count", this.count);
        if (this.scenario != null) {
            params.put("scenario", this.scenario);
        }
        if (this.cascadeCreate != null) {
            params.put("cascadeCreate", this.cascadeCreate);
        }
        if (this.filter != null) {
            params.put("filter", this.filter);
        }
        if (this.booster != null) {
            params.put("booster", this.booster);
        }
        if (this.logic != null) {
            params.put("logic", this.logic);
        }
        if (this.expertSettings != null) {
            params.put("expertSettings", this.expertSettings);
        }
        if (this.returnAbGroup != null) {
            params.put("returnAbGroup", this.returnAbGroup);
        }
        return params;
    }
}

