/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.v3;

import com.google.gson.annotations.SerializedName;
import com.recurly.v3.ClientOptions;
import com.recurly.v3.FileSerializer;
import com.recurly.v3.JsonSerializer;
import com.recurly.v3.NetworkException;
import com.recurly.v3.RecurlyException;
import com.recurly.v3.Request;
import com.recurly.v3.exception.ExceptionFactory;
import com.recurly.v3.http.HeaderInterceptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.joda.time.DateTime;

public abstract class BaseClient {
    private static final List<String> BINARY_TYPES = Arrays.asList("application/pdf");
    private static final JsonSerializer jsonSerializer = new JsonSerializer();
    private static final FileSerializer fileSerializer = new FileSerializer();
    private final String apiKey;
    private final OkHttpClient client;
    private String apiUrl;

    protected BaseClient(String apiKey) {
        this(apiKey, BaseClient.newHttpClient(apiKey), new ClientOptions());
    }

    protected BaseClient(String apiKey, ClientOptions clientOptions) {
        this(apiKey, BaseClient.newHttpClient(apiKey), clientOptions);
    }

    protected BaseClient(String apiKey, OkHttpClient client) {
        this(apiKey, client, new ClientOptions());
    }

    protected BaseClient(String apiKey, OkHttpClient client, ClientOptions clientOptions) {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IllegalArgumentException("apiKey cannot be null or empty");
        }
        this.apiKey = apiKey;
        this.client = client;
        this.apiUrl = clientOptions.getBaseUrl();
    }

    private static OkHttpClient newHttpClient(String apiKey) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        String authToken = Credentials.basic((String)apiKey, (String)"");
        HeaderInterceptor headerInterceptor = new HeaderInterceptor(authToken, "v2021-02-25");
        httpClientBuilder.addInterceptor((Interceptor)headerInterceptor);
        if (BaseClient.envEnabled("RECURLY_INSECURE") && BaseClient.envEnabled("RECURLY_DEBUG")) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
            httpClientBuilder.addInterceptor((Interceptor)logging);
        }
        return httpClientBuilder.build();
    }

    protected static boolean envEnabled(String envVar) {
        return "true".equals(System.getenv(envVar));
    }

    protected void makeRequest(String method, String url) {
        okhttp3.Request request = this.buildRequest(method, url, null, null);
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseString = response.body().string();
                if (BaseClient.envEnabled("RECURLY_INSECURE") && BaseClient.envEnabled("RECURLY_DEBUG")) {
                    System.out.println(responseString);
                }
                throw jsonSerializer.deserializeError(responseString);
            }
            Headers responseHeaders = response.headers();
            if (BaseClient.envEnabled("RECURLY_INSECURE") && BaseClient.envEnabled("RECURLY_DEBUG")) {
                for (int i = 0; i < responseHeaders.size(); ++i) {
                    System.out.println(responseHeaders.name(i) + ": " + responseHeaders.value(i));
                }
            }
            this.warnIfDeprecated(responseHeaders);
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    protected <T> T makeRequest(String method, String url, Type resourceClass) {
        return this.makeRequest(method, url, null, null, resourceClass);
    }

    protected <T> T makeRequest(String method, String url, Request body, Type resourceClass) {
        return this.makeRequest(method, url, body, null, resourceClass);
    }

    protected <T> T makeRequest(String method, String url, HashMap<String, Object> queryParams, Type resourceClass) {
        return this.makeRequest(method, url, null, queryParams, resourceClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T makeRequest(String method, String url, Request body, HashMap<String, Object> queryParams, Type resourceClass) {
        okhttp3.Request request = this.buildRequest(method, url, body, queryParams);
        try (Response response = this.client.newCall(request).execute();){
            Headers responseHeaders = response.headers();
            ResponseBody responseBody = response.body();
            MediaType contentType = responseBody.contentType();
            if (!response.isSuccessful()) {
                if (!contentType.type().equals("application")) throw ExceptionFactory.getExceptionClass(response);
                if (!contentType.subtype().equals("json")) throw ExceptionFactory.getExceptionClass(response);
                throw jsonSerializer.deserializeError(responseBody.string());
            }
            this.warnIfDeprecated(responseHeaders);
            if (BINARY_TYPES.contains(contentType.type() + "/" + contentType.subtype())) {
                Object t = fileSerializer.deserialize(responseBody.bytes(), resourceClass);
                return t;
            }
            Object t = jsonSerializer.deserialize(responseBody.string(), resourceClass);
            return t;
        }
        catch (IOException e) {
            throw new NetworkException(e);
        }
    }

    public int getRecordCount(String url, HashMap<String, Object> queryParams) {
        int n;
        block9: {
            okhttp3.Request request = this.buildRequest("HEAD", url, null, queryParams);
            Response response = this.client.newCall(request).execute();
            try {
                Headers responseHeaders = response.headers();
                ResponseBody responseBody = response.body();
                if (!response.isSuccessful()) {
                    throw jsonSerializer.deserializeError(responseBody.string());
                }
                this.warnIfDeprecated(responseHeaders);
                String count = responseHeaders.get("Recurly-Total-Records");
                n = Integer.parseInt(count);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NetworkException(e);
                }
            }
            response.close();
        }
        return n;
    }

    private String getSerializedEnumName(Enum<?> e) {
        try {
            Field f = e.getClass().getField(e.name());
            SerializedName a = f.getAnnotation(SerializedName.class);
            return a == null ? null : a.value();
        }
        catch (NoSuchFieldException ignored) {
            return null;
        }
    }

    private okhttp3.Request buildRequest(String method, String url, Request body, HashMap<String, Object> queryParams) {
        HttpUrl.Builder httpBuilder = HttpUrl.parse((String)(this.apiUrl + url)).newBuilder();
        RequestBody requestBody = RequestBody.create((String)jsonSerializer.serialize(body), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
        if (queryParams != null) {
            for (Map.Entry<String, Object> param : queryParams.entrySet()) {
                Object value = param.getValue();
                if (value == null) continue;
                String stringValue = value instanceof String ? value.toString() : (value instanceof DateTime ? value.toString() : (value instanceof Integer ? Integer.toString((Integer)value) : (value instanceof Float ? Float.toString(((Float)value).floatValue()) : (value instanceof Double ? Double.toString((Double)value) : (value instanceof Long ? Long.toString((Long)value) : (value instanceof Enum ? this.getSerializedEnumName((Enum)value) : value.toString()))))));
                httpBuilder.addQueryParameter(param.getKey(), stringValue);
            }
        }
        HttpUrl requestUrl = httpBuilder.build();
        if (BaseClient.envEnabled("RECURLY_INSECURE") && BaseClient.envEnabled("RECURLY_DEBUG")) {
            System.out.println("Performing " + method + " request to " + requestUrl);
        }
        Request.Builder requestBuilder = new Request.Builder().url(requestUrl);
        switch (method) {
            case "HEAD": {
                return requestBuilder.head().build();
            }
            case "GET": {
                return requestBuilder.build();
            }
            case "POST": {
                return requestBuilder.post(requestBody).build();
            }
            case "PUT": {
                return requestBuilder.put(requestBody).build();
            }
            case "DELETE": {
                return requestBuilder.delete().build();
            }
        }
        String message = method + " is not a valid Recurly HTTP method";
        throw new IllegalArgumentException(message);
    }

    private void validatePathParameters(HashMap<String, String> urlParams) {
        Map<String, String> invalidParams = urlParams.entrySet().stream().filter(p -> p.getValue() == null || ((String)p.getValue()).trim().isEmpty()).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        if (!invalidParams.isEmpty()) {
            String invalidKeys = String.join((CharSequence)",", invalidParams.keySet());
            throw new RecurlyException(invalidKeys + " cannot be an empty value");
        }
    }

    protected String interpolatePath(String path) {
        return this.interpolatePath(path, new HashMap<String, String>());
    }

    protected String interpolatePath(String path, HashMap<String, String> urlParams) {
        this.validatePathParameters(urlParams);
        Pattern p = Pattern.compile("(\\{[A-Za-z|_]*\\})");
        Matcher m = p.matcher(path);
        while (m.find()) {
            String key = m.group(1).replace("{", "").replace("}", "");
            try {
                String value = URLEncoder.encode(urlParams.get(key), StandardCharsets.UTF_8.toString());
                path = path.replace(m.group(1), value);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RecurlyException(ex.getCause());
            }
        }
        return path.replaceAll("\\{", "").replaceAll("\\}", "");
    }

    public void _setApiUrl(String uri) {
        System.out.println("[SECURITY WARNING] _setApiUrl is for testing only and not supported in production.");
        if (BaseClient.envEnabled("RECURLY_INSECURE")) {
            this.apiUrl = uri;
        } else {
            System.out.println("ApiUrl not changed. To change, set the environment variable RECURLY_INSECURE to true");
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    private void warnIfDeprecated(Headers responseHeaders) {
        String deprecated = responseHeaders.get("Recurly-Deprecated");
        if (deprecated != null && deprecated.toUpperCase() == "TRUE") {
            String sunset = responseHeaders.get("Recurly-Sunset-Date");
            String warning = "[recurly-client-java] WARNING: Your current API version \"v2021-02-25\" is deprecated and will be sunset on " + sunset;
            System.out.println(warning);
        }
    }
}

