/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.v3;

import com.google.gson.reflect.TypeToken;
import com.recurly.v3.BaseClient;
import com.recurly.v3.ClientOptions;
import com.recurly.v3.Pager;
import com.recurly.v3.QueryParams;
import com.recurly.v3.requests.AccountAcquisitionUpdate;
import com.recurly.v3.requests.AccountCreate;
import com.recurly.v3.requests.AccountUpdate;
import com.recurly.v3.requests.AddOnCreate;
import com.recurly.v3.requests.AddOnUpdate;
import com.recurly.v3.requests.BillingInfoCreate;
import com.recurly.v3.requests.BillingInfoVerify;
import com.recurly.v3.requests.BillingInfoVerifyCVV;
import com.recurly.v3.requests.CouponBulkCreate;
import com.recurly.v3.requests.CouponCreate;
import com.recurly.v3.requests.CouponRedemptionCreate;
import com.recurly.v3.requests.CouponUpdate;
import com.recurly.v3.requests.DunningCampaignsBulkUpdate;
import com.recurly.v3.requests.ExternalAccountCreate;
import com.recurly.v3.requests.ExternalAccountUpdate;
import com.recurly.v3.requests.ExternalProductCreate;
import com.recurly.v3.requests.ExternalProductReferenceCreate;
import com.recurly.v3.requests.ExternalProductUpdate;
import com.recurly.v3.requests.ExternalTransaction;
import com.recurly.v3.requests.GeneralLedgerAccountCreate;
import com.recurly.v3.requests.GeneralLedgerAccountUpdate;
import com.recurly.v3.requests.GiftCardCreate;
import com.recurly.v3.requests.GiftCardRedeem;
import com.recurly.v3.requests.InvoiceCollect;
import com.recurly.v3.requests.InvoiceCreate;
import com.recurly.v3.requests.InvoiceRefund;
import com.recurly.v3.requests.InvoiceUpdate;
import com.recurly.v3.requests.ItemCreate;
import com.recurly.v3.requests.ItemUpdate;
import com.recurly.v3.requests.LineItemCreate;
import com.recurly.v3.requests.MeasuredUnitCreate;
import com.recurly.v3.requests.MeasuredUnitUpdate;
import com.recurly.v3.requests.PlanCreate;
import com.recurly.v3.requests.PlanUpdate;
import com.recurly.v3.requests.PurchaseCreate;
import com.recurly.v3.requests.ShippingAddressCreate;
import com.recurly.v3.requests.ShippingAddressUpdate;
import com.recurly.v3.requests.ShippingMethodCreate;
import com.recurly.v3.requests.ShippingMethodUpdate;
import com.recurly.v3.requests.SubscriptionCancel;
import com.recurly.v3.requests.SubscriptionChangeCreate;
import com.recurly.v3.requests.SubscriptionCreate;
import com.recurly.v3.requests.SubscriptionPause;
import com.recurly.v3.requests.SubscriptionUpdate;
import com.recurly.v3.requests.UsageCreate;
import com.recurly.v3.resources.Account;
import com.recurly.v3.resources.AccountAcquisition;
import com.recurly.v3.resources.AccountBalance;
import com.recurly.v3.resources.AccountNote;
import com.recurly.v3.resources.AddOn;
import com.recurly.v3.resources.BillingInfo;
import com.recurly.v3.resources.BinaryFile;
import com.recurly.v3.resources.BusinessEntity;
import com.recurly.v3.resources.Coupon;
import com.recurly.v3.resources.CouponRedemption;
import com.recurly.v3.resources.CreditPayment;
import com.recurly.v3.resources.CustomFieldDefinition;
import com.recurly.v3.resources.DunningCampaign;
import com.recurly.v3.resources.DunningCampaignsBulkUpdateResponse;
import com.recurly.v3.resources.Entitlements;
import com.recurly.v3.resources.ExportDates;
import com.recurly.v3.resources.ExportFiles;
import com.recurly.v3.resources.ExternalAccount;
import com.recurly.v3.resources.ExternalInvoice;
import com.recurly.v3.resources.ExternalPaymentPhase;
import com.recurly.v3.resources.ExternalProduct;
import com.recurly.v3.resources.ExternalProductReferenceCollection;
import com.recurly.v3.resources.ExternalProductReferenceMini;
import com.recurly.v3.resources.ExternalSubscription;
import com.recurly.v3.resources.GeneralLedgerAccount;
import com.recurly.v3.resources.GiftCard;
import com.recurly.v3.resources.Invoice;
import com.recurly.v3.resources.InvoiceCollection;
import com.recurly.v3.resources.InvoiceTemplate;
import com.recurly.v3.resources.Item;
import com.recurly.v3.resources.LineItem;
import com.recurly.v3.resources.MeasuredUnit;
import com.recurly.v3.resources.PerformanceObligation;
import com.recurly.v3.resources.Plan;
import com.recurly.v3.resources.ShippingAddress;
import com.recurly.v3.resources.ShippingMethod;
import com.recurly.v3.resources.Site;
import com.recurly.v3.resources.Subscription;
import com.recurly.v3.resources.SubscriptionChange;
import com.recurly.v3.resources.Transaction;
import com.recurly.v3.resources.UniqueCouponCode;
import com.recurly.v3.resources.UniqueCouponCodeParams;
import com.recurly.v3.resources.Usage;
import java.lang.reflect.Type;
import java.util.HashMap;

public class Client
extends BaseClient {
    public static final String API_VERSION = "v2021-02-25";

    public Client(String apiKey) {
        super(apiKey);
    }

    public Client(String apiKey, ClientOptions clientOptions) {
        super(apiKey, clientOptions);
    }

    public Pager<Site> listSites(QueryParams queryParams) {
        String url = "/sites";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/sites", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Site.class}).getType();
        return new Pager<Site>(path, paramsMap, this, parameterizedType);
    }

    public Site getSite(String siteId) {
        String url = "/sites/{site_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("site_id", siteId);
        String path = this.interpolatePath("/sites/{site_id}", urlParams);
        Class<Site> returnType = Site.class;
        return (Site)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<Account> listAccounts(QueryParams queryParams) {
        String url = "/accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Account.class}).getType();
        return new Pager<Account>(path, paramsMap, this, parameterizedType);
    }

    public Account createAccount(AccountCreate body) {
        String url = "/accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/accounts", urlParams);
        Class<Account> returnType = Account.class;
        return (Account)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Account getAccount(String accountId) {
        String url = "/accounts/{account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}", urlParams);
        Class<Account> returnType = Account.class;
        return (Account)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Account updateAccount(String accountId, AccountUpdate body) {
        String url = "/accounts/{account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}", urlParams);
        Class<Account> returnType = Account.class;
        return (Account)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Account deactivateAccount(String accountId) {
        String url = "/accounts/{account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}", urlParams);
        Class<Account> returnType = Account.class;
        return (Account)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public AccountAcquisition getAccountAcquisition(String accountId) {
        String url = "/accounts/{account_id}/acquisition";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/acquisition", urlParams);
        Class<AccountAcquisition> returnType = AccountAcquisition.class;
        return (AccountAcquisition)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public AccountAcquisition updateAccountAcquisition(String accountId, AccountAcquisitionUpdate body) {
        String url = "/accounts/{account_id}/acquisition";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/acquisition", urlParams);
        Class<AccountAcquisition> returnType = AccountAcquisition.class;
        return (AccountAcquisition)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public void removeAccountAcquisition(String accountId) {
        String url = "/accounts/{account_id}/acquisition";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/acquisition", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Account reactivateAccount(String accountId) {
        String url = "/accounts/{account_id}/reactivate";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/reactivate", urlParams);
        Class<Account> returnType = Account.class;
        return (Account)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public AccountBalance getAccountBalance(String accountId) {
        String url = "/accounts/{account_id}/balance";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/balance", urlParams);
        Class<AccountBalance> returnType = AccountBalance.class;
        return (AccountBalance)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public BillingInfo getBillingInfo(String accountId) {
        String url = "/accounts/{account_id}/billing_info";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info", urlParams);
        Class<BillingInfo> returnType = BillingInfo.class;
        return (BillingInfo)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public BillingInfo updateBillingInfo(String accountId, BillingInfoCreate body) {
        String url = "/accounts/{account_id}/billing_info";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info", urlParams);
        Class<BillingInfo> returnType = BillingInfo.class;
        return (BillingInfo)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public void removeBillingInfo(String accountId) {
        String url = "/accounts/{account_id}/billing_info";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Transaction verifyBillingInfo(String accountId) {
        String url = "/accounts/{account_id}/billing_info/verify";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info/verify", urlParams);
        Class<Transaction> returnType = Transaction.class;
        return (Transaction)this.makeRequest("POST", path, (Type)((Object)returnType));
    }

    public Transaction verifyBillingInfo(String accountId, BillingInfoVerify body) {
        String url = "/accounts/{account_id}/billing_info/verify";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info/verify", urlParams);
        Class<Transaction> returnType = Transaction.class;
        return (Transaction)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Transaction verifyBillingInfoCvv(String accountId, BillingInfoVerifyCVV body) {
        String url = "/accounts/{account_id}/billing_info/verify_cvv";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_info/verify_cvv", urlParams);
        Class<Transaction> returnType = Transaction.class;
        return (Transaction)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<BillingInfo> listBillingInfos(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/billing_infos";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/billing_infos", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{BillingInfo.class}).getType();
        return new Pager<BillingInfo>(path, paramsMap, this, parameterizedType);
    }

    public BillingInfo createBillingInfo(String accountId, BillingInfoCreate body) {
        String url = "/accounts/{account_id}/billing_infos";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_infos", urlParams);
        Class<BillingInfo> returnType = BillingInfo.class;
        return (BillingInfo)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public BillingInfo getABillingInfo(String accountId, String billingInfoId) {
        String url = "/accounts/{account_id}/billing_infos/{billing_info_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("billing_info_id", billingInfoId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_infos/{billing_info_id}", urlParams);
        Class<BillingInfo> returnType = BillingInfo.class;
        return (BillingInfo)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public BillingInfo updateABillingInfo(String accountId, String billingInfoId, BillingInfoCreate body) {
        String url = "/accounts/{account_id}/billing_infos/{billing_info_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("billing_info_id", billingInfoId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_infos/{billing_info_id}", urlParams);
        Class<BillingInfo> returnType = BillingInfo.class;
        return (BillingInfo)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public void removeABillingInfo(String accountId, String billingInfoId) {
        String url = "/accounts/{account_id}/billing_infos/{billing_info_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("billing_info_id", billingInfoId);
        String path = this.interpolatePath("/accounts/{account_id}/billing_infos/{billing_info_id}", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Pager<CouponRedemption> listAccountCouponRedemptions(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/coupon_redemptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/coupon_redemptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CouponRedemption.class}).getType();
        return new Pager<CouponRedemption>(path, paramsMap, this, parameterizedType);
    }

    public Pager<CouponRedemption> listActiveCouponRedemptions(String accountId) {
        String url = "/accounts/{account_id}/coupon_redemptions/active";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/coupon_redemptions/active", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CouponRedemption.class}).getType();
        return new Pager<CouponRedemption>(path, null, this, parameterizedType);
    }

    public CouponRedemption createCouponRedemption(String accountId, CouponRedemptionCreate body) {
        String url = "/accounts/{account_id}/coupon_redemptions/active";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/coupon_redemptions/active", urlParams);
        Class<CouponRedemption> returnType = CouponRedemption.class;
        return (CouponRedemption)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public CouponRedemption removeCouponRedemption(String accountId) {
        String url = "/accounts/{account_id}/coupon_redemptions/active";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/coupon_redemptions/active", urlParams);
        Class<CouponRedemption> returnType = CouponRedemption.class;
        return (CouponRedemption)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<CreditPayment> listAccountCreditPayments(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/credit_payments";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/credit_payments", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CreditPayment.class}).getType();
        return new Pager<CreditPayment>(path, paramsMap, this, parameterizedType);
    }

    public Pager<ExternalAccount> listAccountExternalAccount(String accountId) {
        String url = "/accounts/{account_id}/external_accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/external_accounts", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalAccount.class}).getType();
        return new Pager<ExternalAccount>(path, null, this, parameterizedType);
    }

    public ExternalAccount createAccountExternalAccount(String accountId, ExternalAccountCreate body) {
        String url = "/accounts/{account_id}/external_accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/external_accounts", urlParams);
        Class<ExternalAccount> returnType = ExternalAccount.class;
        return (ExternalAccount)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public ExternalAccount getAccountExternalAccount(String accountId, String externalAccountId) {
        String url = "/accounts/{account_id}/external_accounts/{external_account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("external_account_id", externalAccountId);
        String path = this.interpolatePath("/accounts/{account_id}/external_accounts/{external_account_id}", urlParams);
        Class<ExternalAccount> returnType = ExternalAccount.class;
        return (ExternalAccount)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ExternalAccount updateAccountExternalAccount(String accountId, String externalAccountId, ExternalAccountUpdate body) {
        String url = "/accounts/{account_id}/external_accounts/{external_account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("external_account_id", externalAccountId);
        String path = this.interpolatePath("/accounts/{account_id}/external_accounts/{external_account_id}", urlParams);
        Class<ExternalAccount> returnType = ExternalAccount.class;
        return (ExternalAccount)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public ExternalAccount deleteAccountExternalAccount(String accountId, String externalAccountId) {
        String url = "/accounts/{account_id}/external_accounts/{external_account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("external_account_id", externalAccountId);
        String path = this.interpolatePath("/accounts/{account_id}/external_accounts/{external_account_id}", urlParams);
        Class<ExternalAccount> returnType = ExternalAccount.class;
        return (ExternalAccount)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<ExternalInvoice> listAccountExternalInvoices(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/external_invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/external_invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalInvoice.class}).getType();
        return new Pager<ExternalInvoice>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Invoice> listAccountInvoices(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Invoice.class}).getType();
        return new Pager<Invoice>(path, paramsMap, this, parameterizedType);
    }

    public InvoiceCollection createInvoice(String accountId, InvoiceCreate body) {
        String url = "/accounts/{account_id}/invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/invoices", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public InvoiceCollection previewInvoice(String accountId, InvoiceCreate body) {
        String url = "/accounts/{account_id}/invoices/preview";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/invoices/preview", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<LineItem> listAccountLineItems(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/line_items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/line_items", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{LineItem.class}).getType();
        return new Pager<LineItem>(path, paramsMap, this, parameterizedType);
    }

    public LineItem createLineItem(String accountId, LineItemCreate body) {
        String url = "/accounts/{account_id}/line_items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/line_items", urlParams);
        Class<LineItem> returnType = LineItem.class;
        return (LineItem)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<AccountNote> listAccountNotes(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/notes";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/notes", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{AccountNote.class}).getType();
        return new Pager<AccountNote>(path, paramsMap, this, parameterizedType);
    }

    public AccountNote getAccountNote(String accountId, String accountNoteId) {
        String url = "/accounts/{account_id}/notes/{account_note_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("account_note_id", accountNoteId);
        String path = this.interpolatePath("/accounts/{account_id}/notes/{account_note_id}", urlParams);
        Class<AccountNote> returnType = AccountNote.class;
        return (AccountNote)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<ShippingAddress> listShippingAddresses(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/shipping_addresses";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/shipping_addresses", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ShippingAddress.class}).getType();
        return new Pager<ShippingAddress>(path, paramsMap, this, parameterizedType);
    }

    public ShippingAddress createShippingAddress(String accountId, ShippingAddressCreate body) {
        String url = "/accounts/{account_id}/shipping_addresses";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        String path = this.interpolatePath("/accounts/{account_id}/shipping_addresses", urlParams);
        Class<ShippingAddress> returnType = ShippingAddress.class;
        return (ShippingAddress)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public ShippingAddress getShippingAddress(String accountId, String shippingAddressId) {
        String url = "/accounts/{account_id}/shipping_addresses/{shipping_address_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("shipping_address_id", shippingAddressId);
        String path = this.interpolatePath("/accounts/{account_id}/shipping_addresses/{shipping_address_id}", urlParams);
        Class<ShippingAddress> returnType = ShippingAddress.class;
        return (ShippingAddress)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ShippingAddress updateShippingAddress(String accountId, String shippingAddressId, ShippingAddressUpdate body) {
        String url = "/accounts/{account_id}/shipping_addresses/{shipping_address_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("shipping_address_id", shippingAddressId);
        String path = this.interpolatePath("/accounts/{account_id}/shipping_addresses/{shipping_address_id}", urlParams);
        Class<ShippingAddress> returnType = ShippingAddress.class;
        return (ShippingAddress)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public void removeShippingAddress(String accountId, String shippingAddressId) {
        String url = "/accounts/{account_id}/shipping_addresses/{shipping_address_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        urlParams.put("shipping_address_id", shippingAddressId);
        String path = this.interpolatePath("/accounts/{account_id}/shipping_addresses/{shipping_address_id}", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Pager<Subscription> listAccountSubscriptions(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/subscriptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/subscriptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Subscription.class}).getType();
        return new Pager<Subscription>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Transaction> listAccountTransactions(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/transactions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/transactions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Transaction.class}).getType();
        return new Pager<Transaction>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Account> listChildAccounts(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/accounts", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Account.class}).getType();
        return new Pager<Account>(path, paramsMap, this, parameterizedType);
    }

    public Pager<AccountAcquisition> listAccountAcquisition(QueryParams queryParams) {
        String url = "/acquisitions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/acquisitions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{AccountAcquisition.class}).getType();
        return new Pager<AccountAcquisition>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Coupon> listCoupons(QueryParams queryParams) {
        String url = "/coupons";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/coupons", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Coupon.class}).getType();
        return new Pager<Coupon>(path, paramsMap, this, parameterizedType);
    }

    public Coupon createCoupon(CouponCreate body) {
        String url = "/coupons";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/coupons", urlParams);
        Class<Coupon> returnType = Coupon.class;
        return (Coupon)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Coupon getCoupon(String couponId) {
        String url = "/coupons/{coupon_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        String path = this.interpolatePath("/coupons/{coupon_id}", urlParams);
        Class<Coupon> returnType = Coupon.class;
        return (Coupon)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Coupon updateCoupon(String couponId, CouponUpdate body) {
        String url = "/coupons/{coupon_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        String path = this.interpolatePath("/coupons/{coupon_id}", urlParams);
        Class<Coupon> returnType = Coupon.class;
        return (Coupon)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Coupon deactivateCoupon(String couponId) {
        String url = "/coupons/{coupon_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        String path = this.interpolatePath("/coupons/{coupon_id}", urlParams);
        Class<Coupon> returnType = Coupon.class;
        return (Coupon)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public UniqueCouponCodeParams generateUniqueCouponCodes(String couponId, CouponBulkCreate body) {
        String url = "/coupons/{coupon_id}/generate";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        String path = this.interpolatePath("/coupons/{coupon_id}/generate", urlParams);
        Class<UniqueCouponCodeParams> returnType = UniqueCouponCodeParams.class;
        return (UniqueCouponCodeParams)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Coupon restoreCoupon(String couponId, CouponUpdate body) {
        String url = "/coupons/{coupon_id}/restore";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        String path = this.interpolatePath("/coupons/{coupon_id}/restore", urlParams);
        Class<Coupon> returnType = Coupon.class;
        return (Coupon)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Pager<UniqueCouponCode> listUniqueCouponCodes(String couponId, QueryParams queryParams) {
        String url = "/coupons/{coupon_id}/unique_coupon_codes";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("coupon_id", couponId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/coupons/{coupon_id}/unique_coupon_codes", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{UniqueCouponCode.class}).getType();
        return new Pager<UniqueCouponCode>(path, paramsMap, this, parameterizedType);
    }

    public Pager<CreditPayment> listCreditPayments(QueryParams queryParams) {
        String url = "/credit_payments";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/credit_payments", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CreditPayment.class}).getType();
        return new Pager<CreditPayment>(path, paramsMap, this, parameterizedType);
    }

    public CreditPayment getCreditPayment(String creditPaymentId) {
        String url = "/credit_payments/{credit_payment_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("credit_payment_id", creditPaymentId);
        String path = this.interpolatePath("/credit_payments/{credit_payment_id}", urlParams);
        Class<CreditPayment> returnType = CreditPayment.class;
        return (CreditPayment)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<CustomFieldDefinition> listCustomFieldDefinitions(QueryParams queryParams) {
        String url = "/custom_field_definitions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/custom_field_definitions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CustomFieldDefinition.class}).getType();
        return new Pager<CustomFieldDefinition>(path, paramsMap, this, parameterizedType);
    }

    public CustomFieldDefinition getCustomFieldDefinition(String customFieldDefinitionId) {
        String url = "/custom_field_definitions/{custom_field_definition_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("custom_field_definition_id", customFieldDefinitionId);
        String path = this.interpolatePath("/custom_field_definitions/{custom_field_definition_id}", urlParams);
        Class<CustomFieldDefinition> returnType = CustomFieldDefinition.class;
        return (CustomFieldDefinition)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public GeneralLedgerAccount createGeneralLedgerAccount(GeneralLedgerAccountCreate body) {
        String url = "/general_ledger_accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/general_ledger_accounts", urlParams);
        Class<GeneralLedgerAccount> returnType = GeneralLedgerAccount.class;
        return (GeneralLedgerAccount)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<GeneralLedgerAccount> listGeneralLedgerAccounts(QueryParams queryParams) {
        String url = "/general_ledger_accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/general_ledger_accounts", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{GeneralLedgerAccount.class}).getType();
        return new Pager<GeneralLedgerAccount>(path, paramsMap, this, parameterizedType);
    }

    public GeneralLedgerAccount getGeneralLedgerAccount(String generalLedgerAccountId) {
        String url = "/general_ledger_accounts/{general_ledger_account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("general_ledger_account_id", generalLedgerAccountId);
        String path = this.interpolatePath("/general_ledger_accounts/{general_ledger_account_id}", urlParams);
        Class<GeneralLedgerAccount> returnType = GeneralLedgerAccount.class;
        return (GeneralLedgerAccount)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public GeneralLedgerAccount updateGeneralLedgerAccount(String generalLedgerAccountId, GeneralLedgerAccountUpdate body) {
        String url = "/general_ledger_accounts/{general_ledger_account_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("general_ledger_account_id", generalLedgerAccountId);
        String path = this.interpolatePath("/general_ledger_accounts/{general_ledger_account_id}", urlParams);
        Class<GeneralLedgerAccount> returnType = GeneralLedgerAccount.class;
        return (GeneralLedgerAccount)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public PerformanceObligation getPerformanceObligation(String performanceObligationId) {
        String url = "/performance_obligations/{performance_obligation_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("performance_obligation_id", performanceObligationId);
        String path = this.interpolatePath("/performance_obligations/{performance_obligation_id}", urlParams);
        Class<PerformanceObligation> returnType = PerformanceObligation.class;
        return (PerformanceObligation)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<PerformanceObligation> getPerformanceObligations() {
        String url = "/performance_obligations";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/performance_obligations", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{PerformanceObligation.class}).getType();
        return new Pager<PerformanceObligation>(path, null, this, parameterizedType);
    }

    public Pager<Account> listInvoiceTemplateAccounts(String invoiceTemplateId, QueryParams queryParams) {
        String url = "/invoice_templates/{invoice_template_id}/accounts";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_template_id", invoiceTemplateId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/invoice_templates/{invoice_template_id}/accounts", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Account.class}).getType();
        return new Pager<Account>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Item> listItems(QueryParams queryParams) {
        String url = "/items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/items", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Item.class}).getType();
        return new Pager<Item>(path, paramsMap, this, parameterizedType);
    }

    public Item createItem(ItemCreate body) {
        String url = "/items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/items", urlParams);
        Class<Item> returnType = Item.class;
        return (Item)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Item getItem(String itemId) {
        String url = "/items/{item_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("item_id", itemId);
        String path = this.interpolatePath("/items/{item_id}", urlParams);
        Class<Item> returnType = Item.class;
        return (Item)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Item updateItem(String itemId, ItemUpdate body) {
        String url = "/items/{item_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("item_id", itemId);
        String path = this.interpolatePath("/items/{item_id}", urlParams);
        Class<Item> returnType = Item.class;
        return (Item)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Item deactivateItem(String itemId) {
        String url = "/items/{item_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("item_id", itemId);
        String path = this.interpolatePath("/items/{item_id}", urlParams);
        Class<Item> returnType = Item.class;
        return (Item)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Item reactivateItem(String itemId) {
        String url = "/items/{item_id}/reactivate";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("item_id", itemId);
        String path = this.interpolatePath("/items/{item_id}/reactivate", urlParams);
        Class<Item> returnType = Item.class;
        return (Item)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Pager<MeasuredUnit> listMeasuredUnit(QueryParams queryParams) {
        String url = "/measured_units";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/measured_units", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{MeasuredUnit.class}).getType();
        return new Pager<MeasuredUnit>(path, paramsMap, this, parameterizedType);
    }

    public MeasuredUnit createMeasuredUnit(MeasuredUnitCreate body) {
        String url = "/measured_units";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/measured_units", urlParams);
        Class<MeasuredUnit> returnType = MeasuredUnit.class;
        return (MeasuredUnit)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public MeasuredUnit getMeasuredUnit(String measuredUnitId) {
        String url = "/measured_units/{measured_unit_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("measured_unit_id", measuredUnitId);
        String path = this.interpolatePath("/measured_units/{measured_unit_id}", urlParams);
        Class<MeasuredUnit> returnType = MeasuredUnit.class;
        return (MeasuredUnit)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public MeasuredUnit updateMeasuredUnit(String measuredUnitId, MeasuredUnitUpdate body) {
        String url = "/measured_units/{measured_unit_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("measured_unit_id", measuredUnitId);
        String path = this.interpolatePath("/measured_units/{measured_unit_id}", urlParams);
        Class<MeasuredUnit> returnType = MeasuredUnit.class;
        return (MeasuredUnit)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public MeasuredUnit removeMeasuredUnit(String measuredUnitId) {
        String url = "/measured_units/{measured_unit_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("measured_unit_id", measuredUnitId);
        String path = this.interpolatePath("/measured_units/{measured_unit_id}", urlParams);
        Class<MeasuredUnit> returnType = MeasuredUnit.class;
        return (MeasuredUnit)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<ExternalProduct> listExternalProducts(QueryParams queryParams) {
        String url = "/external_products";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_products", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalProduct.class}).getType();
        return new Pager<ExternalProduct>(path, paramsMap, this, parameterizedType);
    }

    public ExternalProduct createExternalProduct(ExternalProductCreate body) {
        String url = "/external_products";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/external_products", urlParams);
        Class<ExternalProduct> returnType = ExternalProduct.class;
        return (ExternalProduct)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public ExternalProduct getExternalProduct(String externalProductId) {
        String url = "/external_products/{external_product_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        String path = this.interpolatePath("/external_products/{external_product_id}", urlParams);
        Class<ExternalProduct> returnType = ExternalProduct.class;
        return (ExternalProduct)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ExternalProduct updateExternalProduct(String externalProductId, ExternalProductUpdate body) {
        String url = "/external_products/{external_product_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        String path = this.interpolatePath("/external_products/{external_product_id}", urlParams);
        Class<ExternalProduct> returnType = ExternalProduct.class;
        return (ExternalProduct)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public ExternalProduct deactivateExternalProducts(String externalProductId) {
        String url = "/external_products/{external_product_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        String path = this.interpolatePath("/external_products/{external_product_id}", urlParams);
        Class<ExternalProduct> returnType = ExternalProduct.class;
        return (ExternalProduct)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<ExternalProductReferenceCollection> listExternalProductExternalProductReferences(String externalProductId, QueryParams queryParams) {
        String url = "/external_products/{external_product_id}/external_product_references";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_products/{external_product_id}/external_product_references", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalProductReferenceCollection.class}).getType();
        return new Pager<ExternalProductReferenceCollection>(path, paramsMap, this, parameterizedType);
    }

    public ExternalProductReferenceMini createExternalProductExternalProductReference(String externalProductId, ExternalProductReferenceCreate body) {
        String url = "/external_products/{external_product_id}/external_product_references";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        String path = this.interpolatePath("/external_products/{external_product_id}/external_product_references", urlParams);
        Class<ExternalProductReferenceMini> returnType = ExternalProductReferenceMini.class;
        return (ExternalProductReferenceMini)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public ExternalProductReferenceMini getExternalProductExternalProductReference(String externalProductId, String externalProductReferenceId) {
        String url = "/external_products/{external_product_id}/external_product_references/{external_product_reference_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        urlParams.put("external_product_reference_id", externalProductReferenceId);
        String path = this.interpolatePath("/external_products/{external_product_id}/external_product_references/{external_product_reference_id}", urlParams);
        Class<ExternalProductReferenceMini> returnType = ExternalProductReferenceMini.class;
        return (ExternalProductReferenceMini)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ExternalProductReferenceMini deactivateExternalProductExternalProductReference(String externalProductId, String externalProductReferenceId) {
        String url = "/external_products/{external_product_id}/external_product_references/{external_product_reference_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_product_id", externalProductId);
        urlParams.put("external_product_reference_id", externalProductReferenceId);
        String path = this.interpolatePath("/external_products/{external_product_id}/external_product_references/{external_product_reference_id}", urlParams);
        Class<ExternalProductReferenceMini> returnType = ExternalProductReferenceMini.class;
        return (ExternalProductReferenceMini)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<ExternalSubscription> listExternalSubscriptions(QueryParams queryParams) {
        String url = "/external_subscriptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_subscriptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalSubscription.class}).getType();
        return new Pager<ExternalSubscription>(path, paramsMap, this, parameterizedType);
    }

    public ExternalSubscription getExternalSubscription(String externalSubscriptionId) {
        String url = "/external_subscriptions/{external_subscription_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_subscription_id", externalSubscriptionId);
        String path = this.interpolatePath("/external_subscriptions/{external_subscription_id}", urlParams);
        Class<ExternalSubscription> returnType = ExternalSubscription.class;
        return (ExternalSubscription)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<ExternalInvoice> listExternalSubscriptionExternalInvoices(String externalSubscriptionId, QueryParams queryParams) {
        String url = "/external_subscriptions/{external_subscription_id}/external_invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_subscription_id", externalSubscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_subscriptions/{external_subscription_id}/external_invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalInvoice.class}).getType();
        return new Pager<ExternalInvoice>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Invoice> listInvoices(QueryParams queryParams) {
        String url = "/invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Invoice.class}).getType();
        return new Pager<Invoice>(path, paramsMap, this, parameterizedType);
    }

    public Invoice getInvoice(String invoiceId) {
        String url = "/invoices/{invoice_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Invoice updateInvoice(String invoiceId, InvoiceUpdate body) {
        String url = "/invoices/{invoice_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public BinaryFile getInvoicePdf(String invoiceId) {
        String url = "/invoices/{invoice_id}.pdf";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}.pdf", urlParams);
        Class<BinaryFile> returnType = BinaryFile.class;
        return (BinaryFile)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Invoice applyCreditBalance(String invoiceId) {
        String url = "/invoices/{invoice_id}/apply_credit_balance";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/apply_credit_balance", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Invoice collectInvoice(String invoiceId) {
        String url = "/invoices/{invoice_id}/collect";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/collect", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Invoice collectInvoice(String invoiceId, InvoiceCollect body) {
        String url = "/invoices/{invoice_id}/collect";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/collect", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Invoice markInvoiceFailed(String invoiceId) {
        String url = "/invoices/{invoice_id}/mark_failed";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/mark_failed", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Invoice markInvoiceSuccessful(String invoiceId) {
        String url = "/invoices/{invoice_id}/mark_successful";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/mark_successful", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Invoice reopenInvoice(String invoiceId) {
        String url = "/invoices/{invoice_id}/reopen";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/reopen", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Invoice voidInvoice(String invoiceId) {
        String url = "/invoices/{invoice_id}/void";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/void", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Transaction recordExternalTransaction(String invoiceId, ExternalTransaction body) {
        String url = "/invoices/{invoice_id}/transactions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/transactions", urlParams);
        Class<Transaction> returnType = Transaction.class;
        return (Transaction)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<LineItem> listInvoiceLineItems(String invoiceId, QueryParams queryParams) {
        String url = "/invoices/{invoice_id}/line_items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/invoices/{invoice_id}/line_items", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{LineItem.class}).getType();
        return new Pager<LineItem>(path, paramsMap, this, parameterizedType);
    }

    public Pager<CouponRedemption> listInvoiceCouponRedemptions(String invoiceId, QueryParams queryParams) {
        String url = "/invoices/{invoice_id}/coupon_redemptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/invoices/{invoice_id}/coupon_redemptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CouponRedemption.class}).getType();
        return new Pager<CouponRedemption>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Invoice> listRelatedInvoices(String invoiceId) {
        String url = "/invoices/{invoice_id}/related_invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/related_invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Invoice.class}).getType();
        return new Pager<Invoice>(path, null, this, parameterizedType);
    }

    public Invoice refundInvoice(String invoiceId, InvoiceRefund body) {
        String url = "/invoices/{invoice_id}/refund";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_id", invoiceId);
        String path = this.interpolatePath("/invoices/{invoice_id}/refund", urlParams);
        Class<Invoice> returnType = Invoice.class;
        return (Invoice)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<LineItem> listLineItems(QueryParams queryParams) {
        String url = "/line_items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/line_items", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{LineItem.class}).getType();
        return new Pager<LineItem>(path, paramsMap, this, parameterizedType);
    }

    public LineItem getLineItem(String lineItemId) {
        String url = "/line_items/{line_item_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("line_item_id", lineItemId);
        String path = this.interpolatePath("/line_items/{line_item_id}", urlParams);
        Class<LineItem> returnType = LineItem.class;
        return (LineItem)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public void removeLineItem(String lineItemId) {
        String url = "/line_items/{line_item_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("line_item_id", lineItemId);
        String path = this.interpolatePath("/line_items/{line_item_id}", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Pager<Plan> listPlans(QueryParams queryParams) {
        String url = "/plans";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/plans", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Plan.class}).getType();
        return new Pager<Plan>(path, paramsMap, this, parameterizedType);
    }

    public Plan createPlan(PlanCreate body) {
        String url = "/plans";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/plans", urlParams);
        Class<Plan> returnType = Plan.class;
        return (Plan)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Plan getPlan(String planId) {
        String url = "/plans/{plan_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        String path = this.interpolatePath("/plans/{plan_id}", urlParams);
        Class<Plan> returnType = Plan.class;
        return (Plan)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Plan updatePlan(String planId, PlanUpdate body) {
        String url = "/plans/{plan_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        String path = this.interpolatePath("/plans/{plan_id}", urlParams);
        Class<Plan> returnType = Plan.class;
        return (Plan)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Plan removePlan(String planId) {
        String url = "/plans/{plan_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        String path = this.interpolatePath("/plans/{plan_id}", urlParams);
        Class<Plan> returnType = Plan.class;
        return (Plan)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<AddOn> listPlanAddOns(String planId, QueryParams queryParams) {
        String url = "/plans/{plan_id}/add_ons";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/plans/{plan_id}/add_ons", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{AddOn.class}).getType();
        return new Pager<AddOn>(path, paramsMap, this, parameterizedType);
    }

    public AddOn createPlanAddOn(String planId, AddOnCreate body) {
        String url = "/plans/{plan_id}/add_ons";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        String path = this.interpolatePath("/plans/{plan_id}/add_ons", urlParams);
        Class<AddOn> returnType = AddOn.class;
        return (AddOn)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public AddOn getPlanAddOn(String planId, String addOnId) {
        String url = "/plans/{plan_id}/add_ons/{add_on_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        urlParams.put("add_on_id", addOnId);
        String path = this.interpolatePath("/plans/{plan_id}/add_ons/{add_on_id}", urlParams);
        Class<AddOn> returnType = AddOn.class;
        return (AddOn)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public AddOn updatePlanAddOn(String planId, String addOnId, AddOnUpdate body) {
        String url = "/plans/{plan_id}/add_ons/{add_on_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        urlParams.put("add_on_id", addOnId);
        String path = this.interpolatePath("/plans/{plan_id}/add_ons/{add_on_id}", urlParams);
        Class<AddOn> returnType = AddOn.class;
        return (AddOn)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public AddOn removePlanAddOn(String planId, String addOnId) {
        String url = "/plans/{plan_id}/add_ons/{add_on_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("plan_id", planId);
        urlParams.put("add_on_id", addOnId);
        String path = this.interpolatePath("/plans/{plan_id}/add_ons/{add_on_id}", urlParams);
        Class<AddOn> returnType = AddOn.class;
        return (AddOn)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<AddOn> listAddOns(QueryParams queryParams) {
        String url = "/add_ons";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/add_ons", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{AddOn.class}).getType();
        return new Pager<AddOn>(path, paramsMap, this, parameterizedType);
    }

    public AddOn getAddOn(String addOnId) {
        String url = "/add_ons/{add_on_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("add_on_id", addOnId);
        String path = this.interpolatePath("/add_ons/{add_on_id}", urlParams);
        Class<AddOn> returnType = AddOn.class;
        return (AddOn)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<ShippingMethod> listShippingMethods(QueryParams queryParams) {
        String url = "/shipping_methods";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/shipping_methods", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ShippingMethod.class}).getType();
        return new Pager<ShippingMethod>(path, paramsMap, this, parameterizedType);
    }

    public ShippingMethod createShippingMethod(ShippingMethodCreate body) {
        String url = "/shipping_methods";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/shipping_methods", urlParams);
        Class<ShippingMethod> returnType = ShippingMethod.class;
        return (ShippingMethod)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public ShippingMethod getShippingMethod(String shippingMethodId) {
        String url = "/shipping_methods/{shipping_method_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("shipping_method_id", shippingMethodId);
        String path = this.interpolatePath("/shipping_methods/{shipping_method_id}", urlParams);
        Class<ShippingMethod> returnType = ShippingMethod.class;
        return (ShippingMethod)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ShippingMethod updateShippingMethod(String shippingMethodId, ShippingMethodUpdate body) {
        String url = "/shipping_methods/{shipping_method_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("shipping_method_id", shippingMethodId);
        String path = this.interpolatePath("/shipping_methods/{shipping_method_id}", urlParams);
        Class<ShippingMethod> returnType = ShippingMethod.class;
        return (ShippingMethod)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public ShippingMethod deactivateShippingMethod(String shippingMethodId) {
        String url = "/shipping_methods/{shipping_method_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("shipping_method_id", shippingMethodId);
        String path = this.interpolatePath("/shipping_methods/{shipping_method_id}", urlParams);
        Class<ShippingMethod> returnType = ShippingMethod.class;
        return (ShippingMethod)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public Pager<Subscription> listSubscriptions(QueryParams queryParams) {
        String url = "/subscriptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Subscription.class}).getType();
        return new Pager<Subscription>(path, paramsMap, this, parameterizedType);
    }

    public Subscription createSubscription(SubscriptionCreate body) {
        String url = "/subscriptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/subscriptions", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Subscription getSubscription(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Subscription updateSubscription(String subscriptionId, SubscriptionUpdate body) {
        String url = "/subscriptions/{subscription_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Subscription terminateSubscription(String subscriptionId, QueryParams queryParams) {
        String url = "/subscriptions/{subscription_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions/{subscription_id}", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("DELETE", path, paramsMap, (Type)((Object)returnType));
    }

    public Subscription cancelSubscription(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/cancel";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/cancel", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Subscription cancelSubscription(String subscriptionId, SubscriptionCancel body) {
        String url = "/subscriptions/{subscription_id}/cancel";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/cancel", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Subscription reactivateSubscription(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/reactivate";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/reactivate", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Subscription pauseSubscription(String subscriptionId, SubscriptionPause body) {
        String url = "/subscriptions/{subscription_id}/pause";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/pause", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Subscription resumeSubscription(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/resume";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/resume", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public Subscription convertTrial(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/convert_trial";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/convert_trial", urlParams);
        Class<Subscription> returnType = Subscription.class;
        return (Subscription)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public InvoiceCollection getPreviewRenewal(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/preview_renewal";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/preview_renewal", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public SubscriptionChange getSubscriptionChange(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/change";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/change", urlParams);
        Class<SubscriptionChange> returnType = SubscriptionChange.class;
        return (SubscriptionChange)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public SubscriptionChange createSubscriptionChange(String subscriptionId, SubscriptionChangeCreate body) {
        String url = "/subscriptions/{subscription_id}/change";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/change", urlParams);
        Class<SubscriptionChange> returnType = SubscriptionChange.class;
        return (SubscriptionChange)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public void removeSubscriptionChange(String subscriptionId) {
        String url = "/subscriptions/{subscription_id}/change";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/change", urlParams);
        this.makeRequest("DELETE", path);
    }

    public SubscriptionChange previewSubscriptionChange(String subscriptionId, SubscriptionChangeCreate body) {
        String url = "/subscriptions/{subscription_id}/change/preview";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/change/preview", urlParams);
        Class<SubscriptionChange> returnType = SubscriptionChange.class;
        return (SubscriptionChange)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<Invoice> listSubscriptionInvoices(String subscriptionId, QueryParams queryParams) {
        String url = "/subscriptions/{subscription_id}/invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions/{subscription_id}/invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Invoice.class}).getType();
        return new Pager<Invoice>(path, paramsMap, this, parameterizedType);
    }

    public Pager<LineItem> listSubscriptionLineItems(String subscriptionId, QueryParams queryParams) {
        String url = "/subscriptions/{subscription_id}/line_items";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions/{subscription_id}/line_items", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{LineItem.class}).getType();
        return new Pager<LineItem>(path, paramsMap, this, parameterizedType);
    }

    public Pager<CouponRedemption> listSubscriptionCouponRedemptions(String subscriptionId, QueryParams queryParams) {
        String url = "/subscriptions/{subscription_id}/coupon_redemptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions/{subscription_id}/coupon_redemptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{CouponRedemption.class}).getType();
        return new Pager<CouponRedemption>(path, paramsMap, this, parameterizedType);
    }

    public Pager<Usage> listUsage(String subscriptionId, String addOnId, QueryParams queryParams) {
        String url = "/subscriptions/{subscription_id}/add_ons/{add_on_id}/usage";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        urlParams.put("add_on_id", addOnId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/subscriptions/{subscription_id}/add_ons/{add_on_id}/usage", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Usage.class}).getType();
        return new Pager<Usage>(path, paramsMap, this, parameterizedType);
    }

    public Usage createUsage(String subscriptionId, String addOnId, UsageCreate body) {
        String url = "/subscriptions/{subscription_id}/add_ons/{add_on_id}/usage";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("subscription_id", subscriptionId);
        urlParams.put("add_on_id", addOnId);
        String path = this.interpolatePath("/subscriptions/{subscription_id}/add_ons/{add_on_id}/usage", urlParams);
        Class<Usage> returnType = Usage.class;
        return (Usage)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Usage getUsage(String usageId) {
        String url = "/usage/{usage_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("usage_id", usageId);
        String path = this.interpolatePath("/usage/{usage_id}", urlParams);
        Class<Usage> returnType = Usage.class;
        return (Usage)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Usage updateUsage(String usageId, UsageCreate body) {
        String url = "/usage/{usage_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("usage_id", usageId);
        String path = this.interpolatePath("/usage/{usage_id}", urlParams);
        Class<Usage> returnType = Usage.class;
        return (Usage)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public void removeUsage(String usageId) {
        String url = "/usage/{usage_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("usage_id", usageId);
        String path = this.interpolatePath("/usage/{usage_id}", urlParams);
        this.makeRequest("DELETE", path);
    }

    public Pager<Transaction> listTransactions(QueryParams queryParams) {
        String url = "/transactions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/transactions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Transaction.class}).getType();
        return new Pager<Transaction>(path, paramsMap, this, parameterizedType);
    }

    public Transaction getTransaction(String transactionId) {
        String url = "/transactions/{transaction_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("transaction_id", transactionId);
        String path = this.interpolatePath("/transactions/{transaction_id}", urlParams);
        Class<Transaction> returnType = Transaction.class;
        return (Transaction)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public UniqueCouponCode getUniqueCouponCode(String uniqueCouponCodeId) {
        String url = "/unique_coupon_codes/{unique_coupon_code_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("unique_coupon_code_id", uniqueCouponCodeId);
        String path = this.interpolatePath("/unique_coupon_codes/{unique_coupon_code_id}", urlParams);
        Class<UniqueCouponCode> returnType = UniqueCouponCode.class;
        return (UniqueCouponCode)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public UniqueCouponCode deactivateUniqueCouponCode(String uniqueCouponCodeId) {
        String url = "/unique_coupon_codes/{unique_coupon_code_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("unique_coupon_code_id", uniqueCouponCodeId);
        String path = this.interpolatePath("/unique_coupon_codes/{unique_coupon_code_id}", urlParams);
        Class<UniqueCouponCode> returnType = UniqueCouponCode.class;
        return (UniqueCouponCode)this.makeRequest("DELETE", path, (Type)((Object)returnType));
    }

    public UniqueCouponCode reactivateUniqueCouponCode(String uniqueCouponCodeId) {
        String url = "/unique_coupon_codes/{unique_coupon_code_id}/restore";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("unique_coupon_code_id", uniqueCouponCodeId);
        String path = this.interpolatePath("/unique_coupon_codes/{unique_coupon_code_id}/restore", urlParams);
        Class<UniqueCouponCode> returnType = UniqueCouponCode.class;
        return (UniqueCouponCode)this.makeRequest("PUT", path, (Type)((Object)returnType));
    }

    public InvoiceCollection createPurchase(PurchaseCreate body) {
        String url = "/purchases";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/purchases", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public InvoiceCollection previewPurchase(PurchaseCreate body) {
        String url = "/purchases/preview";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/purchases/preview", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public InvoiceCollection createPendingPurchase(PurchaseCreate body) {
        String url = "/purchases/pending";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/purchases/pending", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public InvoiceCollection createAuthorizePurchase(PurchaseCreate body) {
        String url = "/purchases/authorize";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/purchases/authorize", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public InvoiceCollection createCapturePurchase(String transactionId) {
        String url = "/purchases/{transaction_id}/capture";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("transaction_id", transactionId);
        String path = this.interpolatePath("/purchases/{transaction_id}/capture", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, (Type)((Object)returnType));
    }

    public InvoiceCollection cancelpurchase(String transactionId) {
        String url = "/purchases/{transaction_id}/cancel/";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("transaction_id", transactionId);
        String path = this.interpolatePath("/purchases/{transaction_id}/cancel/", urlParams);
        Class<InvoiceCollection> returnType = InvoiceCollection.class;
        return (InvoiceCollection)this.makeRequest("POST", path, (Type)((Object)returnType));
    }

    public ExportDates getExportDates() {
        String url = "/export_dates";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/export_dates", urlParams);
        Class<ExportDates> returnType = ExportDates.class;
        return (ExportDates)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public ExportFiles getExportFiles(String exportDate) {
        String url = "/export_dates/{export_date}/export_files";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("export_date", exportDate);
        String path = this.interpolatePath("/export_dates/{export_date}/export_files", urlParams);
        Class<ExportFiles> returnType = ExportFiles.class;
        return (ExportFiles)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<DunningCampaign> listDunningCampaigns(QueryParams queryParams) {
        String url = "/dunning_campaigns";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/dunning_campaigns", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{DunningCampaign.class}).getType();
        return new Pager<DunningCampaign>(path, paramsMap, this, parameterizedType);
    }

    public DunningCampaign getDunningCampaign(String dunningCampaignId) {
        String url = "/dunning_campaigns/{dunning_campaign_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("dunning_campaign_id", dunningCampaignId);
        String path = this.interpolatePath("/dunning_campaigns/{dunning_campaign_id}", urlParams);
        Class<DunningCampaign> returnType = DunningCampaign.class;
        return (DunningCampaign)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public DunningCampaignsBulkUpdateResponse putDunningCampaignBulkUpdate(String dunningCampaignId, DunningCampaignsBulkUpdate body) {
        String url = "/dunning_campaigns/{dunning_campaign_id}/bulk_update";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("dunning_campaign_id", dunningCampaignId);
        String path = this.interpolatePath("/dunning_campaigns/{dunning_campaign_id}/bulk_update", urlParams);
        Class<DunningCampaignsBulkUpdateResponse> returnType = DunningCampaignsBulkUpdateResponse.class;
        return (DunningCampaignsBulkUpdateResponse)this.makeRequest("PUT", path, body, (Type)((Object)returnType));
    }

    public Pager<InvoiceTemplate> listInvoiceTemplates(QueryParams queryParams) {
        String url = "/invoice_templates";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/invoice_templates", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{InvoiceTemplate.class}).getType();
        return new Pager<InvoiceTemplate>(path, paramsMap, this, parameterizedType);
    }

    public InvoiceTemplate getInvoiceTemplate(String invoiceTemplateId) {
        String url = "/invoice_templates/{invoice_template_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("invoice_template_id", invoiceTemplateId);
        String path = this.interpolatePath("/invoice_templates/{invoice_template_id}", urlParams);
        Class<InvoiceTemplate> returnType = InvoiceTemplate.class;
        return (InvoiceTemplate)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<ExternalInvoice> listExternalInvoices(QueryParams queryParams) {
        String url = "/external_invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalInvoice.class}).getType();
        return new Pager<ExternalInvoice>(path, paramsMap, this, parameterizedType);
    }

    public ExternalInvoice showExternalInvoice(String externalInvoiceId) {
        String url = "/external_invoices/{external_invoice_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_invoice_id", externalInvoiceId);
        String path = this.interpolatePath("/external_invoices/{external_invoice_id}", urlParams);
        Class<ExternalInvoice> returnType = ExternalInvoice.class;
        return (ExternalInvoice)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<ExternalPaymentPhase> listExternalSubscriptionExternalPaymentPhases(String externalSubscriptionId, QueryParams queryParams) {
        String url = "/external_subscriptions/{external_subscription_id}/external_payment_phases";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_subscription_id", externalSubscriptionId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/external_subscriptions/{external_subscription_id}/external_payment_phases", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalPaymentPhase.class}).getType();
        return new Pager<ExternalPaymentPhase>(path, paramsMap, this, parameterizedType);
    }

    public ExternalPaymentPhase getExternalSubscriptionExternalPaymentPhase(String externalSubscriptionId, String externalPaymentPhaseId) {
        String url = "/external_subscriptions/{external_subscription_id}/external_payment_phases/{external_payment_phase_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("external_subscription_id", externalSubscriptionId);
        urlParams.put("external_payment_phase_id", externalPaymentPhaseId);
        String path = this.interpolatePath("/external_subscriptions/{external_subscription_id}/external_payment_phases/{external_payment_phase_id}", urlParams);
        Class<ExternalPaymentPhase> returnType = ExternalPaymentPhase.class;
        return (ExternalPaymentPhase)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<Entitlements> listEntitlements(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/entitlements";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/entitlements", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Entitlements.class}).getType();
        return new Pager<Entitlements>(path, paramsMap, this, parameterizedType);
    }

    public Pager<ExternalSubscription> listAccountExternalSubscriptions(String accountId, QueryParams queryParams) {
        String url = "/accounts/{account_id}/external_subscriptions";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("account_id", accountId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/accounts/{account_id}/external_subscriptions", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{ExternalSubscription.class}).getType();
        return new Pager<ExternalSubscription>(path, paramsMap, this, parameterizedType);
    }

    public BusinessEntity getBusinessEntity(String businessEntityId) {
        String url = "/business_entities/{business_entity_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("business_entity_id", businessEntityId);
        String path = this.interpolatePath("/business_entities/{business_entity_id}", urlParams);
        Class<BusinessEntity> returnType = BusinessEntity.class;
        return (BusinessEntity)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public Pager<BusinessEntity> listBusinessEntities() {
        String url = "/business_entities";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/business_entities", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{BusinessEntity.class}).getType();
        return new Pager<BusinessEntity>(path, null, this, parameterizedType);
    }

    public Pager<GiftCard> listGiftCards() {
        String url = "/gift_cards";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/gift_cards", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{GiftCard.class}).getType();
        return new Pager<GiftCard>(path, null, this, parameterizedType);
    }

    public GiftCard createGiftCard(GiftCardCreate body) {
        String url = "/gift_cards";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/gift_cards", urlParams);
        Class<GiftCard> returnType = GiftCard.class;
        return (GiftCard)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public GiftCard getGiftCard(String giftCardId) {
        String url = "/gift_cards/{gift_card_id}";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("gift_card_id", giftCardId);
        String path = this.interpolatePath("/gift_cards/{gift_card_id}", urlParams);
        Class<GiftCard> returnType = GiftCard.class;
        return (GiftCard)this.makeRequest("GET", path, (Type)((Object)returnType));
    }

    public GiftCard previewGiftCard(GiftCardCreate body) {
        String url = "/gift_cards/preview";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        String path = this.interpolatePath("/gift_cards/preview", urlParams);
        Class<GiftCard> returnType = GiftCard.class;
        return (GiftCard)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public GiftCard redeemGiftCard(String redemptionCode, GiftCardRedeem body) {
        String url = "/gift_cards/{redemption_code}/redeem";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("redemption_code", redemptionCode);
        String path = this.interpolatePath("/gift_cards/{redemption_code}/redeem", urlParams);
        Class<GiftCard> returnType = GiftCard.class;
        return (GiftCard)this.makeRequest("POST", path, body, (Type)((Object)returnType));
    }

    public Pager<Invoice> listBusinessEntityInvoices(String businessEntityId, QueryParams queryParams) {
        String url = "/business_entities/{business_entity_id}/invoices";
        HashMap<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("business_entity_id", businessEntityId);
        if (queryParams == null) {
            queryParams = new QueryParams();
        }
        HashMap<String, Object> paramsMap = queryParams.getParams();
        String path = this.interpolatePath("/business_entities/{business_entity_id}/invoices", urlParams);
        Type parameterizedType = TypeToken.getParameterized(Pager.class, (Type[])new Type[]{Invoice.class}).getType();
        return new Pager<Invoice>(path, paramsMap, this, parameterizedType);
    }
}

